# coding=utf-8
import yt.wrapper as yt
import argparse
import requests
import simplejson as json


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--yt_token', required=True, help='Hahn Yt token')
    parser.add_argument('--tracker_token', required=True, help='Tracker token')
    parser.add_argument('--yt_pool', required=False, help='yt_pool')
    parser.add_argument('--main_goal', required=True, help='GoalID')
    parser.add_argument('--goals_table', required=True, help='Result table at yt')

    args = parser.parse_args()
    goals_table = args.goals_table
    main_goal = args.main_goal
    tracker_token = args.tracker_token
    yt_token = args.yt_token
    yt_pool = args.yt_pool

    goals = []
    ids = []

    template_info = 'https://st-api.yandex-team.ru/v2/issues/GOALZ-{}'
    template_children = 'https://st-api.yandex-team.ru/v2/issues/GOALZ-{}/links'

    template_goals_url = 'https://goals.yandex-team.ru/filter?goal={}'
    template_okr_url = 'https://goals.yandex-team.ru/okr?selectedItem={}&goal={}'

    goals = []
    ids = []

    def get_data():
        next_id = ids.pop(0)

        response = requests.get(template_info.format(next_id),
                                           headers={'Authorization': 'OAuth {}'.format(tracker_token)})
        if response.status_code == 200:
            result = json.loads(response.text)
            try:
                data = {}
                data['goal_id'] = next_id.replace('GOALZ-', '')
                data['title'] = result['summary'].replace('\t', '').replace('\n', '')
                data['responsible'] = result['assignee']['display']
                data['type'] = result['type']['key']
                data['status'] = result['status']['display']
                if result['type']['key'] == 'vs':
                    data['parent_id'] = main_goal
                    data['url'] = template_goals_url.format(next_id)
                else:
                    data['parent_id'] = result['parentIssueLinkChain']['chain'][0]['issue']['key'].replace('GOALZ-', '')
                    data['url'] = template_okr_url.format(main_goal, next_id)
                goals.append(data)

                response = requests.get(template_children.format(next_id),
                                                headers={'Authorization': 'OAuth {}'.format(tracker_token)})
                result = json.loads(response.text)

                for item in result:
                    if item['direction'] == 'outward' and item['type']['id'] == 'subtask':
                        ids.append(item['object']['key'].replace('GOALZ-', ''))

            except KeyError:
                pass

    ids.append(main_goal)
    while (len(ids) > 0):
        get_data()

    yt.config["proxy"]["url"] = "hahn"
    yt.config["token"] = yt_token
    yt.config["pool"] = yt_pool
    yt.write_table(goals_table, goals, format=yt.JsonFormat(attributes={"encode_utf8": False}), raw=False,
                   force_create=True)


if __name__ == "__main__":
    main()
