# coding=utf-8
import yt.wrapper as yt
import argparse
import requests
import simplejson as json


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--yt_token', required=True, help='Hahn Yt token')
    parser.add_argument('--warden_token', required=True, help='warden token')
    parser.add_argument('--yt_pool', required=False, help='yt_pool')
    parser.add_argument('--table', required=True, help='Result table at yt')

    args = parser.parse_args()
    table = args.table
    warden_token = args.warden_token
    yt_token = args.yt_token
    yt_pool = args.yt_pool

    components = ['trust', 'billing', 'oebs', 'paymentsonservices', 'ofd', 'spirit']
    metrics_list = ['billing money loss', 'billing_downtime', 'billing_money_loss',
                    'oebs_availability', 'oebs_money_loss', 'oebs_nr_money_loss',
                    'oebs_plan_downtime', 'ofd_downtime', 'spirit_downtime',
                    'trust_downtime', 'trust_money_loss_nonref', 'trust_money_loss']
    incidents = []

    def format_metric(m):
        if m in ['billing money loss', 'billing30_money_loss']:
            return 'billing_money_loss'
        else:
            return m

    for component in components:
        response = requests.post(
            'https://warden.z.yandex-team.ru/api/warden.Warden/getReport',
            headers={'Authorization': 'OAuth {}'.format(warden_token)},
            json={
                "componentName": component,
                "period": "all",
                "customPeriod": {
                    "start": 1640984000,
                },
            }
        )
        result = json.loads(response.text)

        try:
            for incident in result['incidents']:
                data = {}

                data['service'] = component
                data['title'] = incident['summary'].replace('\t', '').replace('  ', '').replace('\n', '')
                data['ticket_url'] = 'https://st.yandex-team.ru/' + incident['key']

                try:
                    metric = incident['metrics']
                    for current_metric in metric:
                        try:
                            if (current_metric['metricKey']) in metrics_list:
                                try:
                                    metric_name = format_metric(current_metric['metricKey'])
                                    if(current_metric['value'] > 0):
                                        data[metric_name] = float(current_metric['value'])
                                except(KeyError):
                                    pass
                        except(KeyError):
                            pass
                except(KeyError):
                    pass
                incidents.append(data)
        except(KeyError):
            pass

    yt.config["proxy"]["url"] = "hahn"
    yt.config["token"] = yt_token
    yt.config["pool"] = yt_pool
    yt.write_table(table, incidents, format=yt.JsonFormat(attributes={"encode_utf8": False}), raw=False,
                   force_create=True)


if __name__ == "__main__":
    main()
