# coding=utf-8
import yt.wrapper as yt
import argparse
from xml.etree import ElementTree
import requests
from datetime import date


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--yt_token', required=True, help='Hahn Yt token')
    parser.add_argument('--yt_pool', required=False, help='yt_pool')
    parser.add_argument('--yt_table', required=True, help='Result table at yt')

    args = parser.parse_args()
    yt_table = args.yt_table
    yt_token = args.yt_token
    yt_pool = args.yt_pool

    start = '2021-11-01'
    sp_coeff = 0.704

    template = 'http://calendar.yandex-team.ru/export/holidays.xml?start_date={0}&country_id=225&for_yandex=1&out_mode=all&end_date='.format(
        start)

    SP_calendar = []

    def get_month(dt):
        return dt[:7] + '-01'

    def get_holidays():
        host = template + date.today().strftime("%Y-%m-%d")
        response = requests.get(host)
        string_xml = response.content

        tree = ElementTree.fromstring(string_xml)

        SP_from_start_of_month = 0
        previous_month = start
        raw_calendar = {}
        SP_by_month = {}

        for elem in tree.iter():
            if (elem.tag == 'day'):
                current_dt = elem.get('date')
                current_month = get_month(current_dt)
                is_holiday = int(elem.get('is-holiday'))

                SP = sp_coeff * (1 - is_holiday)

                if (current_dt == current_month):
                    SP_by_month[previous_month] = round(SP_from_start_of_month, 3)
                    previous_month = current_month
                    SP_from_start_of_month = 0

                current = {}
                current['dt'] = current_dt
                current['month'] = current_month
                current['SP'] = SP
                SP_from_start_of_month += SP
                current['SP_from_start_of_month'] = round(SP_from_start_of_month, 3)
                raw_calendar[current_dt] = current

        for dt in raw_calendar:
            current = {}
            current['dt'] = raw_calendar[dt]['dt']
            current['month'] = raw_calendar[dt]['month']
            current['SP'] = raw_calendar[dt]['SP']
            current['SP_from_start_of_month'] = raw_calendar[dt]['SP_from_start_of_month']

            if raw_calendar[dt]['month'] in SP_by_month:
                current['SP_month'] = SP_by_month[raw_calendar[dt]['month']]
            else:
                current['SP_month'] = SP_from_start_of_month

            SP_calendar.append(current)

        return

    get_holidays()

    yt.config["proxy"]["url"] = "hahn"
    yt.config["token"] = yt_token
    yt.config["pool"] = yt_pool
    yt.write_table(yt_table, SP_calendar, format=yt.JsonFormat(attributes={"encode_utf8": False}), raw=False,
                   force_create=True)


if __name__ == "__main__":
    main()
