#!/usr/bin/env python
# -*- coding: utf-8 -*-

import json
import logging
import subprocess
import shlex
import traceback

import requests

requests.packages.urllib3.disable_warnings()


class ResetBlackEmails(object):
    def __init__(
            self,
            black_emails,
            log_file=None,
            uids_file='pwd_change_uids.txt',
            out_file='pwd_change_uids.out',
            err_file='pwd_change_uids.err'
    ):
        self.black_emails = black_emails
        self.serv_ticket_bb, _ = self._execute_command(
            '/usr/bin/tvmknife get_service_ticket client_credentials -s *** -d *** -S *** -q')
        self.serv_ticket_api, _ = self._execute_command(
            '/usr/bin/tvmknife get_service_ticket client_credentials -s *** -d *** -S *** -q')
        self.email_bindings_url = 'https://blackbox.yandex.net/blackbox/?method=email_bindings&email={0}&format=json'
        self.api_url = 'https://passport-internal.yandex.ru/1/bundle/account/reset/email/?consumer=passport_antifraud_team'
        self.user_agent = 'ResetEmailClient'
        self.headers_bb = {'X-Ya-Service-Ticket': self.serv_ticket_bb.rstrip(), 'User-Agent': self.user_agent}
        self.headers_api = {'X-Ya-Service-Ticket': self.serv_ticket_api.rstrip(), 'User-Agent': self.user_agent}
        self.log_file = log_file
        self.uids_file = uids_file
        self.out_file = out_file
        self.err_file = err_file
        self._setup_logger()
        self.hacked = []

    def _setup_logger(self):
        if self.log_file is not None:
            logging.basicConfig(
                format='%(levelname)-4s [%(asctime)s] %(message)s',
                level=logging.INFO,
                filename=self.log_file
            )
            self.logger = logging.getLogger(__name__)

    @staticmethod
    def _execute_command(command, stdin=None):
        com_exec = subprocess.Popen(shlex.split(command), stdin=subprocess.PIPE,
                                    stdout=subprocess.PIPE, stderr=subprocess.PIPE)
        if stdin:
            out, err = com_exec.communicate(input=stdin)
        else:
            out, err = com_exec.communicate()
        return out, err

    def _find_hacked(self):
        for black_email in self.black_emails:
            blackbox_url = self.email_bindings_url.format(black_email)
            try:
                blackbox_data = requests.get(blackbox_url, headers=self.headers_bb, timeout=10).json()
                for uid in blackbox_data['uids']:
                    self.hacked.append((uid, black_email))
            except Exception:
                self.logger.error('Error during processing email_bindings {0}, traceback: {1}'.format(
                    black_email, traceback.print_exc()))
                continue

    def _unbind(self, uid, email):
        data = {'uid': uid, 'email': email}
        req = requests.post(self.api_url, data=data, headers=self.headers_api, timeout=100, verify=False)
        self.logger.info('data: {0}, api response: {1}, response code: {2}'.format(
            json.dumps(data), json.dumps(req.json()), req.status_code))

    def _unbind_hacked(self):
        for item in self.hacked:
            self._unbind(item[0], item[1])

    def _send_pwd_change(self):
        uids = set()
        with open(self.uids_file, 'w') as outfile:
            for item in self.hacked:
                uid = item[0]
                if len(uid) <= 10:  # фильтруем ПДД
                    uids.add(uid)
                    outfile.write('{0}\n'.format(uid))

        cmd = 'sudo /opt/bin/admkarma.py -a logout -c"{0}" -i {1} -o {2} -e {3} --max_change_frequency 0'.format(
            'PTANALYTICS-179', self.uids_file, self.out_file, self.err_file
        )
        out, err = self._execute_command(cmd)
        if out:
            print('Out: {0}'.format(out))
        if err:
            print('Err: {0}'.format(err))

        print('На смену пароля отправлено {0} уидов.'.format(len(uids)))

    def run(self):
        self._find_hacked()
        if not self.hacked:
            print('Hacked list is empty.')
            return
        self._unbind_hacked()
        self._send_pwd_change()


if __name__ == '__main__':
    emails_blacklist = set()
    with open('blacklist.txt') as infile:
        for line in infile:
            email = line.rstrip()
            emails_blacklist.add(email)
            emails_blacklist.add(email.lower())
    reset_black_emails = ResetBlackEmails(black_emails=emails_blacklist, log_file='blacklist.log')
    reset_black_emails.run()
