#!/usr/bin/env python
# -*- coding: utf-8 -*-

import json
import logging
import subprocess
import shlex
import traceback
from Queue import Queue
from threading import Thread

import requests
import yt.wrapper as yt

yt.config["proxy"]["url"] = "hahn"
yt.config["auto_merge_output"]["action"] = "merge"

requests.packages.urllib3.disable_warnings()


class ResetHqHa(object):
    def __init__(self, input_table, threads_num=3, log_file=None):
        self.input_table = input_table
        self.threads_num = threads_num
        self.input_queue = self._get_input_queue()
        print('Количество уидов: {0}'.format(len(list(self.input_queue.queue))))
        self.output_queue = Queue()
        self.serv_ticket, _ = self.execute_command(
            '/usr/bin/tvmknife get_service_ticket client_credentials -s *** -d *** -S *** -q')
        self.url = 'https://passport-internal.yandex.ru/1/bundle/account/reset/question/?consumer=passport_antifraud_team'
        self.user_agent = 'ResetHintClient'
        self.headers = {'X-Ya-Service-Ticket': self.serv_ticket.rstrip(), 'User-Agent': self.user_agent}
        self.log_file = log_file
        self._setup_logger()

    def _setup_logger(self):
        if self.log_file is not None:
            logging.basicConfig(
                format='%(levelname)-4s [%(asctime)s] %(message)s',
                level=logging.INFO,
                filename=self.log_file
            )
            self.logger = logging.getLogger(__name__)

    @staticmethod
    def execute_command(command, stdin=None):
        com_exec = subprocess.Popen(shlex.split(command), stdin=subprocess.PIPE,
                                    stdout=subprocess.PIPE, stderr=subprocess.PIPE)
        if stdin:
            out, err = com_exec.communicate(input=stdin)
        else:
            out, err = com_exec.communicate()
        return out, err

    def _get_input_queue(self):
        input_queue = Queue()
        for record in yt.read_table(self.input_table):
            input_queue.put(str(record['uid']))
        return input_queue

    def _run_multi_threading(self, func, queue):
        for _ in xrange(self.threads_num):
            worker = Thread(target=func)
            worker.setDaemon(True)
            worker.start()
        queue.join()

    def unbind(self, uid):
        data = {'uid': uid}
        req = requests.post(self.url, data=data, headers=self.headers, timeout=100, verify=False)
        self.logger.info('data: {0}, api response: {1}, response code: {2}'.format(
            json.dumps(data), json.dumps(req.json()), req.status_code))

    def _worker(self):
        while True:
            uid = self.input_queue.get()
            if not uid:
                self.input_queue.task_done()
                return
            try:
                self.unbind(uid)
                self.input_queue.task_done()
            except Exception:
                self.logger.error('Error during processing {0}, traceback: {1}'.format(
                    json.dumps(uid), traceback.print_exc()))
                self.input_queue.task_done()
                continue

    def run(self):
        self._run_multi_threading(func=self._worker, queue=self.input_queue)


def get_yt_tables(yt_folder):
    yt_tables = []
    for table_name in json.loads(yt.get(yt_folder, format=yt.JsonFormat())).iterkeys():
        table_path = yt.ypath_join(yt_folder, table_name)
        print('Found table: {0}'.format(table_path))
        yt_tables.append(table_path)
    return yt_tables


if __name__ == '__main__':
    yt_folders = ['//home/ecosystem/_squeezes_/brute_detector/fast_iron_hand/output/hint_reset']
    for folder in yt_folders:
        yt_tables = get_yt_tables(folder)

        for table in yt_tables:
            reset_hqha = ResetHqHa(input_table=table, log_file='auto.log')
            reset_hqha.run()
            yt.remove(table, force=True)
