PRAGMA yt.PoolTrees = "physical";
PRAGMA yt.TentativePoolTrees = "cloud";

USE hahn;

DECLARE $day AS String;
DECLARE $prefix AS String?;
DECLARE $id AS String;
DECLARE $timestamp AS Int64;

$prefix = $prefix ?? '//home/mssngr/private';
$revision = CAST($timestamp AS String) || '_' || $id;

$yesterday = CAST(CAST($day AS Date) - DateTime::IntervalFromDays(1) AS String);

$chat_members_old = $prefix || '/current_state/chat_members/' || $yesterday;
$chat_members_new = $prefix || '/current_state_data/chat_members/' || $day || '/' || $revision;
$chat_accession = $prefix || '/chat_accession/' || $day;

INSERT INTO $chat_members_new WITH TRUNCATE
SELECT guid, chat_id, MAX(`timestamp`) AS `timestamp`
FROM (
    SELECT chat_id, guid, 'from_the_start' AS event, `timestamp`,
    FROM $chat_members_old

    UNION ALL

    SELECT chat_id, guid, event, `timestamp`
    FROM $chat_accession
    WITH SCHEMA Struct<chat_id:string, guid:string, event:string, `timestamp`:int64>
)
GROUP BY guid, chat_id
HAVING MAX_BY(event, `timestamp`) IN ('add', 'invite', 'from_the_start');
