PRAGMA yt.PoolTrees = "physical";
PRAGMA yt.TentativePoolTrees = "cloud";

USE hahn;

DECLARE $day AS String;
DECLARE $prefix AS String?;
DECLARE $id AS String;
DECLARE $timestamp AS Int64;

$prefix = $prefix ?? '//home/mssngr/private';
$revision = CAST($timestamp AS String) || '_' || $id;

$chats_schema = Struct<
    chat_id:string,
    create_timestamp:int64,
    name:string?,
    namespace:int64,
    org_id:int64,
    version:int64,
    invite_hash:string?,
    author:string?,
    moderation_disabled:string?,
    subservice:int64?,
    show_on_morda:string?,
>;

$yesterday = CAST(CAST($day AS Date) - DateTime::IntervalFromDays(1) AS String);

$chats_old = $prefix || '/current_state/chats/' || $yesterday;
$chats_new = $prefix || '/current_state_data/chats/' || $day || '/' || $revision;
$chats = $prefix || '/chats/' || $day;

INSERT INTO  $chats_new  WITH TRUNCATE
SELECT * FROM
(
    SELECT *
    FROM $chats_old AS l
    LEFT ONLY JOIN $chats
    WITH SCHEMA $chats_schema AS c
    USING (chat_id)

    UNION ALL

    SELECT
        chat_id,
        create_timestamp,
        name,
        namespace,
        org_id,
        version,
        invite_hash,
        author,
        moderation_disabled,
        subservice,
        CAST(show_on_morda AS bool) ?? false AS show_on_morda,
    FROM $chats
    WITH SCHEMA $chats_schema
)
ORDER BY chat_id;
