PRAGMA yt.PoolTrees = "physical";
PRAGMA yt.TentativePoolTrees = "cloud";

USE hahn;

DECLARE $day AS String;
DECLARE $prefix AS String?;
DECLARE $id AS String;
DECLARE $timestamp AS Int64;

$prefix = $prefix ?? '//home/mssngr/private';
$tester_table = $prefix || '/current_state/users_testers';
$revision = CAST($timestamp AS String) || '_' || $id;

$user_table_schema = Struct<
    guid:string,
    organizations:string?,
    nickname:string?,
    org_id:int32,
    puid:int64,
    version:int64,
    is_robot:bool,
    is_limit:bool,
>;

$users_table = $prefix || '/users/' || $day;

-- update testers
INSERT INTO $tester_table WITH TRUNCATE
SELECT
    testers.nickname AS nickname,
    testers.org_id AS org_id,
    testers.guid ?? all_users.guid AS guid,
    true AS is_tester,
FROM $tester_table AS testers
LEFT JOIN (
    SELECT
        guid,
        nickname,
        org_id,
    FROM $users_table
    WITH SCHEMA $user_table_schema
) AS all_users
USING (nickname, org_id)
ORDER BY guid;

-- Add tester info
$tester_info = (
    SELECT
        new_users.guid AS guid,
        organizations,
        nickname,
        org_id,
        puid,
        version,
        is_robot,
        is_limit,
        is_tester ?? false AS is_tester,
    FROM (
        SELECT
            guid,
            organizations,
            nickname,
            org_id,
            puid,
            version,
            is_robot,
            is_limit,
        FROM
            $users_table
        WITH SCHEMA $user_table_schema
    ) AS new_users
    LEFT JOIN (
        SELECT
            guid,
            is_tester,
        FROM
            $tester_table
    ) AS testers
    USING (guid)
);

-- Get banned users
$week_ago = CAST(CAST($day AS Date) - DateTime::IntervalFromDays(6) AS STRING);

$type = ($rules_categories) -> (
    CASE
        WHEN 'strict_private' IN $rules_categories THEN 'private'
        WHEN 'strict' IN $rules_categories THEN 'public'
        WHEN 'content' IN $rules_categories THEN 'public'
        WHEN 'content_first_level' IN $rules_categories THEN 'public'
        ELSE NULL
    END
);

$banned_users = (
    SELECT
        puid,
        'private' IN AGGREGATE_LIST(type) AS private_days,
        'public' IN AGGREGATE_LIST(type) AS public_days,
    FROM (
        SELECT
            puid,
            $type(Yson::ConvertToStringList(rules_categories)) AS type,
        FROM (
            SELECT * FROM RANGE(`//home/antifraud/xurma/afraudita/prod/analytics/db/1d/mssngr-log`, $week_ago, $day)
            UNION ALL
            SELECT * FROM RANGE(`//logs/antifraud-online-prod-db-common/1d`, $week_ago, $day)
        )
        WHERE
            puid != '0'
            AND $type(Yson::ConvertToStringList(rules_categories)) IS NOT NULL
    )
    GROUP BY puid
);

-- Merge new users
$yesterday = CAST(CAST($day AS Date) - DateTime::IntervalFromDays(1) AS STRING);

$users_old = $prefix || '/current_state/users/' || $yesterday;
$users_new = $prefix || '/current_state_data/users/' || $day || '/' || $revision;

INSERT INTO  $users_new WITH TRUNCATE
SELECT
    u.guid AS guid,
    u.nickname AS nickname,
    u.puid AS puid,
    u.organizations AS organizations,
    u.org_id AS org_id,
    u.is_limit AS is_limit,
    u.is_tester AS is_tester,
    u.is_robot AS is_robot,
    u.version AS version,
    bu.public_days ?? False AS is_public_banned,
    bu.private_days ?? False AS is_private_banned,
FROM (
    SELECT *
    FROM $users_old AS l
    LEFT ONLY JOIN $tester_info AS ti
    USING (guid)

    UNION ALL

    SELECT *
    FROM $tester_info
) AS u
LEFT JOIN $banned_users AS bu
ON CAST(u.puid AS String) == bu.puid
ORDER BY guid;

COMMIT;

-- yandex-team filter
$team_users = $prefix || '/current_state/users_team';

INSERT INTO $team_users WITH TRUNCATE
SELECT
    guid,
    nickname,
    true AS is_team,
FROM $users_new
WHERE org_id = 34
ORDER BY guid;
