PRAGMA yt.PoolTrees = "physical";
PRAGMA yt.TentativePoolTrees = "cloud";

USE hahn;

$day_from = '2020-06-01';
$day_to = '2020-06-01';
$prefix = '//home/mssngr/private';
$revision = '1592989740_update_fraud_v1';
$users = '//home/mssngr/private/current_state/users';

$get_table_name = ($path) -> (
    ListLast(String::SplitToList($path, '/'))
);

$days = (
    SELECT AGGREGATE_LIST($get_table_name(Path))
    FROM FOLDER($users)
    WHERE
        Type = 'table'
        AND $get_table_name(Path) BETWEEN $day_from AND $day_to
);

$type = ($rules_categories) -> (
    CASE
        WHEN 'strict_private' IN $rules_categories THEN 'private'
        WHEN 'strict' IN $rules_categories THEN 'public'
        WHEN 'content' IN $rules_categories THEN 'public'
        WHEN 'content_first_level' IN $rules_categories THEN 'public'
        ELSE NULL
    END
);

EVALUATE FOR $day IN $days DO BEGIN
    -- Get banned users
    $week_ago = CAST(CAST($day AS Date) - DateTime::IntervalFromDays(6) AS STRING);

    $banned_users = (
        SELECT
            puid,
            'private' IN AGGREGATE_LIST(type) AS private_days,
            'public' IN AGGREGATE_LIST(type) AS public_days,
        FROM (
            SELECT
                puid,
                $type(Yson::ConvertToStringList(rules_categories)) AS type,
            FROM (
                SELECT * FROM RANGE(`//home/antifraud/xurma/afraudita/prod/analytics/db/1d/mssngr-log`, $week_ago, $day)
                UNION ALL
                SELECT * FROM RANGE(`//home/antifraud/xurma/newonline/prod/responder/analytics/db/1d`, $week_ago, $day)
            )
            WHERE
                puid != '0'
                AND $type(Yson::ConvertToStringList(rules_categories)) IS NOT NULL
        )
        GROUP BY puid
    );

    -- update users
    $users_old = $users || '/' || $day;
    $users_new = $prefix || '/current_state_data/users/' || $day || '/' || $revision;

    INSERT INTO  $users_new WITH TRUNCATE
    SELECT
        u.guid AS guid,
        u.nickname AS nickname,
        u.puid AS puid,
        u.organizations AS organizations,
        u.org_id AS org_id,
        u.is_limit AS is_limit,
        u.is_tester AS is_tester,
        u.is_robot AS is_robot,
        u.version AS version,
        bu.public_days ?? False AS is_public_banned,
        bu.private_days ?? False AS is_private_banned,
    FROM $users_old AS u
    LEFT JOIN $banned_users AS bu
    ON CAST(u.puid AS String) == bu.puid
    ORDER BY guid;
END DO;
