USE hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

DECLARE $day AS String;
DECLARE $numdays AS Integer;

$dates = ListMap(ListFromRange(0, $numdays), ($d) -> {
    RETURN DateTime::MakeDate(DateTime::Parse('%Y-%m-%d')($day)) - $d * Interval('P1D');
});

$first_day = DateTime::Format('%Y-%m-%d')(Unwrap($dates[ListLength($dates) - 1]));

DEFINE SUBQUERY $all_tables($path) AS
    SELECT * FROM RANGE($path, $first_day, $day);
END DEFINE;

$output_table = "//home/mssngr/squeeze/dashboard_datasets/app_installations";

INSERT INTO $output_table WITH TRUNCATE
SELECT
    day,
    APIKey,
    COUNT(*) AS installations
FROM $all_tables("logs/metrika-mobile-install-log/1d")
WHERE IsReinstallation = "0" AND
    (APIKey = "2126725" AND AppID IN ('ru.yandex.mobile.yamb', 'ru.yandex.messenger')) OR
    ((APIKey = "1630031" OR APIKey= "3071014") AND AppID IN ('com.yandex.yamb', 'com.yandex.yamb.canary'))
GROUP BY CAST(InstallationDate AS Date) AS day, APIKey
UNION ALL
SELECT * FROM $output_table
WHERE day NOT IN $dates;
