use hahn;

DECLARE $day AS String;

$input_table = '//home/mssngr/squeeze/calls/data/Call_info_oneliner_'||$day;
$output_table = '//home/mssngr/squeeze/calls/dashboard/'||$day;


$tmp_output = (
    SELECT     
        `call_guid`,
        `callee_id`,
        `caller_id`,
        `ended`,
        `expired`,
        `failed`,
        `fielddate`,
        `host_from`,
        `host_to`,
        `invalid`,
        `msg_acceptcall`,
        `msg_endcall`,
        `msg_makecall`,
        `not_accepted`,
        `platform_from`,
        `platform_to`,
        `time_accepted`,
        `time_created`,
        `time_ended`,
        `time_ice_completed`,
        `call`,
        `call_duration`,
        `ice_duration`,
        (callee_id IN (SELECT guid as callee_id FROM `//home/mssngr/private/current_state/users_team`)
            or caller_id IN (SELECT guid as caller_id FROM `//home/mssngr/private/current_state/users_team`)) as `is_team`,
        (caller_id IN (select guid as caller_id from `//home/mssngr/private/current_state/users_testers`) 
            or callee_id IN (select guid as callee_id from `//home/mssngr/private/current_state/users_testers`)) as `is_tester`
    FROM $input_table
);




INSERT INTO $output_table WITH TRUNCATE 
SELECT     
    `call_guid`,
    `callee_id` as `caller_id`,
    `caller_id` as `callee_id`,
    `ended`,
    `expired`,
    `failed`,
    `fielddate`,
    `host_from`,
    `host_to`,
    `invalid`,
    `msg_acceptcall`,
    `msg_endcall`,
    `msg_makecall`,
    `not_accepted`,
    `platform_from`,
    `platform_to`,
    `time_accepted`,
    `time_created`,
    `time_ended`,
    `time_ice_completed`,
    `call`,
    `call_duration`,
    `ice_duration`,
    `is_team`,
    `is_tester`,
    TRUE as `is_reversed`
FROM $tmp_output
UNION ALL
SELECT     
    `call_guid`,
    `callee_id`,
    `caller_id`,
    `ended`,
    `expired`,
    `failed`,
    `fielddate`,
    `host_from`,
    `host_to`,
    `invalid`,
    `msg_acceptcall`,
    `msg_endcall`,
    `msg_makecall`,
    `not_accepted`,
    `platform_from`,
    `platform_to`,
    `time_accepted`,
    `time_created`,
    `time_ended`,
    `time_ice_completed`,
    `call`,
    `call_duration`,
    `ice_duration`,
    `is_team`,
    `is_tester`,
    False as `is_reversed`
FROM $tmp_output;
