USE hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yt.TemporaryAutoMerge = "disabled";
PRAGMA Library('messenger_lib.sql');

IMPORT messenger_lib SYMBOLS $default_filter;

DECLARE $scale as STRING;
$scale = IF ($scale IS NULL OR $scale NOT IN ('wau', 'mau'), 'dau', $scale);


$scale_date = ($date, $scale) -> {RETURN
CASE $scale
    WHEN 'wau' THEN CAST(DateTime::MakeDate(DateTime::StartOfWeek(CAST($date as Date))) as STRING)
    WHEN 'mau' THEN CAST(DateTime::MakeDate(DateTime::StartOfMonth(CAST($date as Date))) as STRING)
    ELSE $date
END};

$stats = SELECT
    fielddate,
    CountDistinctEstimate(guid) AS guids,
    CountDistinctEstimate(guid_1on1) AS guids_1on1,
    CountDistinctEstimate(guid_group_chat) AS guids_group_chat,
    CountDistinctEstimate(puid) AS puids,
    CountDistinctEstimate(puid_1on1) AS puids_1on1,
    CountDistinctEstimate(puid_group_chat) AS puids_group_chat
FROM (
    SELECT
        fielddate,
        guid,
        puid,
        IF ( chat_type = '1on1' or chat_id like '0/0/%', guid) AS guid_1on1,
        IF (chat_type = '1on1' or chat_id like '0/0/%', puid) AS puid_1on1,
        IF (not (chat_type = '1on1' or chat_id like '0/0/%'), guid) AS guid_group_chat,
        IF (not (chat_type = '1on1' or chat_id like '0/0/%'), puid) AS puid_group_chat
    FROM Range(`//home/mssngr/squeeze/sent_messages`, `2020-03-01`)
    WHERE $default_filter(TableRow()) AND NOT to_robot
)
GROUP BY $scale_date(fielddate, $scale) as fielddate;
    
$stats = SELECT
    fielddate,
    guids,
    guids_1on1,
    guids_group_chat,
    puids,
    puids_1on1,
    puids_group_chat,
    CAST(AVG(guids) OVER w AS UInt64) AS guids_week_avg,
    CAST(AVG(guids_1on1) OVER w AS UInt64) AS guids_1on1_week_avg,
    CAST(AVG(guids_group_chat) OVER w AS UInt64) AS guids_group_chat_week_avg,
    CAST(AVG(puids) OVER w AS UInt64) AS puids_week_avg,
    CAST(AVG(puids_1on1) OVER w AS UInt64) AS puids_1on1_week_avg,
    CAST(AVG(puids_group_chat) OVER w AS UInt64) AS puids_group_chat_week_avg
FROM $stats
WINDOW w AS (
    ORDER BY fielddate
    ROWS BETWEEN 6 PRECEDING AND CURRENT ROW
);

$output_table = '//home/mssngr/squeeze/dashboard_datasets/'||$scale||'_stats';
INSERT INTO  $output_table WITH TRUNCATE
SELECT * FROM $stats;
