USE hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yt.TemporaryAutoMerge = "disabled";
PRAGMA Library('messenger_lib.sql');

IMPORT messenger_lib SYMBOLS $Russian_origin, $default_filter;

DECLARE $scale as STRING;
$scale = IF ($scale IS NULL OR $scale NOT IN ('wau', 'mau'), 'dau', $scale);


$scale_date = ($date, $scale) -> {RETURN
CASE $scale
    WHEN 'wau' THEN CAST(DateTime::MakeDate(DateTime::StartOfWeek(CAST($date as Date))) as STRING)
    WHEN 'mau' THEN CAST(DateTime::MakeDate(DateTime::StartOfMonth(CAST($date as Date))) as STRING)
    ELSE $date
END};

$stats = SELECT
    fielddate,
    origin,
    CountDistinctEstimate(guid) AS guids,
    CountDistinctEstimate(puid) AS puids
FROM Range(`//home/mssngr/squeeze/sent_messages`, `2020-03-01`)
WHERE $default_filter(TableRow()) AND NOT to_robot
    AND (chat_type = '1on1' OR chat_id LIKE '0/0/%')
GROUP COMPACT BY $scale_date(fielddate, $scale) as fielddate, $Russian_origin(origin, is_team) AS origin;
    
$stats = SELECT
    fielddate,
    origin,
    guids,
    puids,
    CAST(AVG(guids) OVER w AS UInt64) AS guids_week_avg,
    CAST(AVG(puids) OVER w AS UInt64) AS puids_week_avg
FROM $stats
WINDOW w AS (
    PARTITION BY origin
    ORDER BY fielddate
    ROWS BETWEEN 6 PRECEDING AND CURRENT ROW
);

$output_table = '//home/mssngr/squeeze/dashboard_datasets/' || $scale|| '_origin_stats';
INSERT INTO $output_table WITH TRUNCATE
SELECT * FROM $stats;
