PRAGMA yt.TemporaryAutoMerge = 'disabled';
PRAGMA yt.DataSizePerJob = '50M';
$origin_names = {
    0: 'UNSET',
    1: 'SERVICES',
    2: 'SERP',
    3: 'LOCAL',
    4: 'ETHER',
    5: 'IOS_SEARCHAPP',
    6: 'IOS_BROWSER',
    7: 'IOS_STANDALONE',
    8: 'BRINGLY',
    9: 'BERU',
    10: 'MORDA',
    11: 'WIDGET_ON_WEBSITE',
    12: 'MARKET',
    13: 'MAP',
    14: 'TRAVEL',
    15: 'DIRECT',
    16: 'GEO',
    17: 'ANDROID',
    18: 'COLLECTIONS',
    19: 'HEALTH',
    20: 'LMS',
    21: 'AURA',
    22: 'TALENTS',
    23: 'TURBO_LANDING_CONSTRUCTOR',
    24: 'ANDROID_SEARCHAPP',
    25: 'ANDROID_BROWSER',
    26: 'ANDROID_STANDALONE',
    27: 'WEB',
    28: 'ELECTRON_APP',
    29: 'CMNT',
    30: 'DESKTOP_YABRO',
};
$service_namespace_names =  {
    0: 'user_created',
    2: 'geochatbot',
    3: 'commentator',
    6: 'local',
    7: 'ether',
    9: 'browser_api',
    14: 'rtx',
};


$default_filter = ($tr) -> (
    $tr.event_subtype='sending' 
    AND $tr.to_count 
    AND NOT $tr.is_robot 
    AND NOT $tr.is_tester
    AND NOT $tr.is_team
);

$first_dates = select MIN(CAST(fielddate as Date)) as first_day, puid
from range(`//home/mssngr/squeeze/sent_messages`, `2020-03-01`)
group by puid;

insert into `//home/mssngr/squeeze/first_stats_messages` WITH TRUNCATE 
select 
    day, 
    source,
    to_robot,
    user_type,
    message_type,
    namespace_name,
    new_puid,
    anonymous,
    chat_type,
    CountDistinctEstimate((guid, payload_id)) as messages
from range(`//home/mssngr/squeeze/sent_messages`, `2020-04-01`) as a
left join any $first_dates as f using(puid)
where $default_filter(TableRow())
group by     
    CAST(a.fielddate as Date) as day, 
    $origin_names[a.origin] ?? 'UNKNOWN' as source, 
    a.to_robot as to_robot,
    a.user_type as user_type,
    a.chat_type as chat_type,
    $service_namespace_names[a.namespace] ?? 'other' as namespace_name,
    a.is_reply ?? 'normal' as message_type,
    CAST(a.fielddate as Date) <= f.first_day as new_puid,
    not ((a.puid ?? 0) > 0 ) as anonymous
order by day
