--10321 - android
--42989 - ios

use hahn;
PRAGMA yson.DisableStrict;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yt.InferSchema = '1';
DECLARE $day as String;
DECLARE $numdays as Integer;

$dates = ListMap(ListFromRange(0, $numdays), ($d) -> {
    RETURN DateTime::Format('%Y-%m-%d')(DateTime::MakeDate(DateTime::Parse('%Y-%m-%d')($day)) - $d * Interval('P1D')) ?? '';
});

$first_day = Unwrap($dates[ListLength($dates) - 1]);

$makedate = ($ts, $j) ->{
 $res = DateTime::Format('%Y-%m-%d')(IF($j=0,DateTime::FromSeconds(CAST($ts as Uint32)), DateTime::FromMicroseconds(CAST($ts as Uint64))));
 RETURN ($res)
};

DEFINE SUBQUERY $all_tables($path) AS
    SELECT * FROM RANGE($path, $first_day, $day);
END DEFINE;

$channel_data = '//home/mssngr/private/chat_accession'; --timestamp 1597017604841078
$app_metrica_path = '//home/logfeller/logs/appmetrica-events-log/appmetrica-yandex-events/1d'; --EventTimestamp 1597694112
$backforwards = '//home/logfeller/logs/mssngr-router-event-log/1d'; -- event_timestamp 1597675946980049
$sent_messages = '//home/mssngr/squeeze/sent_messages'; --fielddate

$key_value = ($ReportEnvironment_Keys,$ReportEnvironment_Values)->
{

RETURN ToDict(ListZipAll($ReportEnvironment_Keys, $ReportEnvironment_Values))
};

$corona = (SELECT chat_id FROM `//home/mssngr/private/current_state/corona_channels`);

$get_channel = ($chat_id)->
{
RETURN ( ($chat_id LIKE '%chat_id:1\\/%') OR ($chat_id LIKE '%id:1\\/%') OR ($chat_id LIKE '%1/%'));
};

$seen_chatlist = ($APIKey,$EventName,$path)->
{RETURN (($APIKey = 1630031 and $EventName in ('chatlist opened') ) or  ($APIKey = 2126725 and $EventName = 'q_shown' and $path ='ChatList' ))
};

$seen_chat = ($APIKey,$EventName,$path) ->
{RETURN ( ($APIKey = 1630031 and $EventName = 'chat opened') or  ($APIKey = 2126725 and $EventName = 'q_shown' and $path = 'Chat' ))
};

$forward_buttons_1 = ($APIKey,$EventName,$path)->
{RETURN ( $EventName = 'q_tap' and $path in ('\/chat\/subscribe\/share_button', 'Chat/ForwardMessageButton' )) }
;

$forward_buttons_2 = ($APIKey,$EventName,$path)->
{RETURN ( $EventName = 'q_tap' and $path in ('\/chat\/subscribe\/share_text', 'Chat/ForwardChannelPanel' )) }
;

$forward_buttons_3 = ($APIKey,$EventName,$path)->
{RETURN ( $EventName = 'q_tap' and ($path in ('/chat/subscribe/button_share','/chat/subscribe/button_forward', 'Chat/MultiselectionToolbar/Forward' ) or $path like '%dialog_item_forward_button%')  ) 
};

-- Chat/ForwardChannelPanel -- /chat/subscribe/share_text
-- Chat/ForwardMessageButton -- /chat/subscribe/share_button
-- Chat/MultiselectionToolbar/Forward -- /chat/subscribe/button_share, /chat/subscribe/button_forward


INSERT INTO @android_data (SELECT $makedate(EventTimestamp,0) as fielddate, APIKey, EventName, AppID, `UUID` as user_uid,  Yson::LookupString(Yson::ParseJson(EventValue),'path') as path, CAST($key_value(ReportEnvironment_Keys,ReportEnvironment_Values)["guid"] as String) as guid, (Yson::LookupString(Yson::ParseJson(EventValue),'chat_id') ?? Yson::LookupString(Yson::ParseJson(EventValue),'args') ) as chat_id
FROM $all_tables($app_metrica_path)
WHERE APIKey in (1630031) AND SessionType IS NULL)
;

INSERT INTO @ios_data (SELECT $makedate(EventTimestamp,0) as fielddate, APIKey, EventName, AppID, `UUID` as user_uid,  Yson::LookupString(Yson::ParseJson(EventValue),'path') as path, Yson::LookupString(Yson::ParseJson(EventValue),'guid') as guid, Yson::LookupString(Yson::ParseJson(EventValue),'args') as chat_id
FROM $all_tables($app_metrica_path)
WHERE APIKey in (2126725) AND SessionType IS NULL)
;

COMMIT;

$all_data = (
SELECT *
FROM @android_data
UNION ALL
SELECT *
FROM @ios_data
);

$channels =
(SELECT fielddate, APIKey,EventName,AppID, user_uid, guid, chat_id, path
FROM $all_data
WHERE $get_channel(chat_id)
);

$seen_chatlist = (SELECT DISTINCT fielddate, APIKey, AppID, user_uid, guid
FROM $all_data
WHERE $seen_chatlist(APIKey,EventName,path) 
);

-- потом distinct
$seen_any_chat = (SELECT fielddate, APIKey, AppID, user_uid, guid, chat_id
FROM $all_data
WHERE $seen_chat(APIKey,EventName,path)
);

-- потом distinct
$seen_channel = (SELECT fielddate, APIKey, AppID, user_uid, guid, chat_id
FROM $channels
WHERE $seen_chat(APIKey,EventName,path)
);

-- потом distinct
$subscribe = (SELECT $makedate(`timestamp`,1) as fielddate, guid, chat_id
FROM $all_tables($channel_data)
WHERE chat_id LIKE '1/%' and event in ('invite')
); 

$reaction = ();


$tap_forward = (
SELECT fielddate, APIKey, AppID, guid,  MAX(fb1) as fb1,MAX(fb2) as fb2, MAX(fb3) as fb3
FROM
(SELECT fielddate, APIKey, AppID, guid, IF($forward_buttons_1(APIKey,EventName,path),1,0) as fb1, IF($forward_buttons_2(APIKey,EventName,path),1,0) as fb2, IF($forward_buttons_3(APIKey,EventName,path),1,0) as fb3
FROM $channels
WHERE $forward_buttons_1(APIKey,EventName,path) or $forward_buttons_2(APIKey,EventName,path) or $forward_buttons_3(APIKey,EventName,path))
GROUP BY fielddate, APIKey, AppID, guid
);

-- $forward_0 = (
-- select *
-- FROM 
--     (SELECT frame_id, source_uri, $makedate(event_timestamp,1) as fielddate 
--     FROM
--     $all_tables($backforwards) 
--     WHERE ForwardedMessageCount > 0) as a 
-- JOIN
--     (select frame_id, source_uri, ChatId as chat_id, $makedate(event_timestamp,1) as fielddate  
--     FROM
--     $all_tables($backforwards) 
--     WHERE event_name = 'TDepResolutionInfo' AND ChatId LIKE '1/%') as b
-- USING (frame_id, source_uri, fielddate)
-- );

-- -- потом distinct
-- $forward_1 = (
-- SELECT l.fielddate as fielddate, r.guid as guid, r.puid as puid, l.from_chat_id as chat_id, r.chat_id as to_chat_id
-- FROM 
-- (SELECT frame_id, source_uri, chat_id as from_chat_id, fielddate FROM $forward_0) as l
-- LEFT JOIN
-- (SELECT frame_id, source_uri, fielddate, chat_id, guid, puid FROM $all_tables($sent_messages)
-- ) as r 
-- USING (frame_id, source_uri, fielddate));


$forward_1 = (
SELECT fielddate, guid, puid, forward_chat_id as chat_id, chat_id as to_chat_id
FROM $all_tables($sent_messages)
WHERE forward_chat_id LIKE '1/%');

$tab = '//home/mssngr/squeeze/funnel_channel_data';


$all_mssng_users = (
SELECT a.fielddate ?? b.fielddate as fielddate, a.APIKey ?? b.APIKey as APIKey, a.AppID ?? b.AppID as AppID, a.user_uid ?? b.user_uid as user_uid, a.guid ?? b.guid as guid, a.seen_chatlist as seen_chatlist, b.seen_chat as seen_chat
FROM
(SELECT DISTINCT  fielddate, APIKey, AppID, user_uid, guid, 1 as seen_chatlist
FROM $seen_chatlist) as a
FULL JOIN 
(SELECT DISTINCT fielddate, APIKey, AppID, user_uid, guid, 1 as seen_chat
FROM $seen_any_chat) as b
ON a.fielddate = b.fielddate and a.APIKey = b.APIKey and a.AppID = b.AppID and a.guid = b.guid
WHERE a.guid is not null or b.guid is not null
);

$all_mssng_users_1 = (
SELECT *
    FROM $all_mssng_users as a
    LEFT JOIN 
    ( SELECT DISTINCT fielddate, APIKey, AppID, guid, 1 as seen_channel FROM $seen_channel) as b
    USING (fielddate, APIKey, AppID, guid)
);


$all_mssng_users_2=
(SELECT *
FROM $all_mssng_users_1 as a
LEFT JOIN
(SELECT DISTINCT fielddate, guid, 1 as subscribe FROM $subscribe) as b
USING (fielddate, guid)
);

$all_mssng_users_3 =
(SELECT *
FROM $all_mssng_users_2 as a
LEFT JOIN
(SELECT DISTINCT fielddate, guid, APIKey, AppID,  1 as anyforwardbutton FROM $tap_forward) as b
USING (fielddate, APIKey, AppID, guid)
);

$forwards_2 = (
SELECT fielddate, guid, MAX(backforward) as backforward, MAX(notselfforward) as notselfforward
FROM
(SELECT fielddate, guid, 1 as backforward,  IF(to_chat_id!=guid||'_'||guid,1,0) as notselfforward
FROM $forward_1   )
GROUP BY fielddate, guid
);

INSERT INTO $tab WITH TRUNCATE 
SELECT * FROM $tab as t
WHERE fielddate not in $dates
UNION ALL
(SELECT CAST(APIKey as STRING) as APIKey, t.* WITHOUT APIKey from 
(SELECT *
FROM $all_mssng_users_3 as a
LEFT JOIN $forwards_2 as b
USING (fielddate, guid)
WHERE a.fielddate in $dates) as t);

COMMIT;

$result_tab = '//home/mssngr/squeeze/funnel_channel_data_summary';
INSERT INTO $result_tab WITH TRUNCATE 
SELECT fielddate, CAST(APIKey as STRING) as APIKey,AppID, COUNT(distinct guid) as all, COUNT_IF(seen_chatlist=1 or seen_chat=1) as msg_users, COUNT_IF(seen_channel=1) as channel_users, COUNT_IF(seen_channel=1 and subscribe=1) as chan_and_subscribe, COUNT_IF(subscribe=1) as subscribe, COUNT_IF(anyforwardbutton=1) as forward_button, COUNT_IF(anyforwardbutton=1 and backforward=1) as forward_back,COUNT_IF(backforward=1) as forward_back_only, COUNT_IF(anyforwardbutton=1 and notselfforward=1) as forward_notself
FROM $tab
WHERE AppID in ('ru.yandex.messenger','com.yandex.yamb','com.yandex.launcher','com.yandex.browser.alpha','ru.yandex.mobile.yamb','com.yandex.yamb.canary','com.yandex.browser.beta','com.yandex.browser','ru.yandex.searchplugin.beta','ru.yandex.mobile.search.ipad','ru.yandex.searchplugin','ru.yandex.mobile','ru.yandex.mobile.search')
GROUP BY fielddate, APIKey,AppID
;


