use hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yson.DisableStrict;

DECLARE $day as String;
DECLARE $numdays as Integer;
$dates = ListMap(ListFromRange(0, $numdays), ($d) -> {
    RETURN DateTime::Format('%Y-%m-%d')(DateTime::MakeDate(DateTime::Parse('%Y-%m-%d')($day)) - $d * Interval('P1D')) ?? '';
});
$first_day = Unwrap($dates[ListLength($dates) - 1]);

DEFINE SUBQUERY $all_tables($path) AS
    SELECT * FROM RANGE($path, $first_day, $day);
END DEFINE;
$moscow_date = ($ts) -> {RETURN DateTime::Format("%Y-%m-%d")(DateTime::StartOfDay(AddTimezone(CAST($ts AS DateTime), 'Europe/Moscow')));};

$makedate = ($ts, $j) ->{
 $res = DateTime::Format('%Y-%m-%d')(IF($j=0,DateTime::FromSeconds(CAST($ts as Uint32)), DateTime::FromMicroseconds(CAST($ts as Uint64))));
 RETURN ($res)
};

$today = CAST(CurrentUTCDate() - DateTime::IntervalFromDays(1) as STRING);
$users_table = '//home/mssngr/private/current_state/users/2021-03-31';
-- ||$today;

$users = (select guid, puid from $users_table);


$get_guid = ($keys, $values) ->
{
RETURN $values[ListIndexOf($keys, 'guid')];};


$to_name = ($ui) -> {RETURN IF($ui LIKE '%ok', 'balloon_ok', 'balloon_cancel');};



$appmetrika = '//home/logfeller/logs/appmetrica-yandex-events/1d';
$appmetrika_pp = '//home/logfeller/logs/superapp-metrika-mobile-log/1d';

$ios_balloon = (select CAST(IF(AccountID = '', '0', AccountID) as Int64) as puid, IF(Yson::LookupString(Yson::ParseJson(EventValue), 'uiUsed') LIKE '%ok', 'balloon_ok', 'balloon_cancel') as event, 'ios' as platform, AppID, AppBuildNumber, $makedate(EventTimestamp,0) as fielddate
from $all_tables($appmetrika_pp)
WHERE APIKey == 42989
    AND EventName == 'MOBILE_UI_TOUCH_EVENT'
    AND Yson::LookupString(Yson::ParseJson(EventValue), 'uiUsed') like '%chatsWelcomeBalloon%');

$android_balloon_ok_guid = (select $get_guid(`ReportEnvironment_Keys`, `ReportEnvironment_Values`) as guid, 'balloon_ok' as event, 'android' as platform, AppID, AppBuildNumber, $makedate(EventTimestamp,0) as fielddate from $all_tables($appmetrika)
WHERE APIKey = 1630031
    AND EventName = 'q_tap'
    AND Yson::LookupString(Yson::ParseJson(EventValue), 'path') = '/onboarding_features_try_button');
    
$android_balloon_cancel = (select  CAST(IF(AccountID = '', '0', AccountID) as Int64) as puid, 'balloon_cancel' as event, 'android' as platform, AppID, AppBuildNumber, $makedate(EventTimestamp,0) as fielddate from $all_tables($appmetrika_pp)
    WHERE APIKey == 10321
    AND EventName == 'MOBILE_UI_TOUCH_EVENT'
    AND Yson::LookupString(Yson::ParseJson(EventValue), 'uiUsed') like '%messenger_close_button');
    
$android_onboarding_events_guid = (select $get_guid(`ReportEnvironment_Keys`, `ReportEnvironment_Values`) as guid, EventName||'_'||Yson::LookupString(Yson::ParseJson(EventValue), 'path') as event, 'android' as platform, AppID, AppBuildNumber, $makedate(EventTimestamp,0) as fielddate from $all_tables($appmetrika)
WHERE APIKey = 1630031
    AND EventName IN ('q_tap', 'q_shown')
    AND Yson::LookupString(Yson::ParseJson(EventValue), 'path') LIKE '%onboarding%');
    
$ios_onboarding_events_guid = (select $get_guid(`ReportEnvironment_Keys`, `ReportEnvironment_Values`) as guid, EventName||'_'||Yson::LookupString(Yson::ParseJson(EventValue), 'path') as event, 'ios' as platform, AppID, AppBuildNumber, $makedate(EventTimestamp,0) as fielddate from $all_tables($appmetrika)
    WHERE APIKey = 2126725
    AND EventName IN ('q_tap', 'q_shown')
    AND Yson::LookupString(Yson::ParseJson(EventValue), 'path') LIKE '%Onboarding%');
    
$android_true_onboarding_events_guid = (select $get_guid(`ReportEnvironment_Keys`, `ReportEnvironment_Values`) as guid, EventName as event, 'android' as platform, AppID, AppBuildNumber, $makedate(EventTimestamp,0) as fielddate from $all_tables($appmetrika)
    WHERE APIKey = 1630031
        AND EventName IN ('onboarding start', 'onboarding interrupted', 'onboarding finished'));
        
$ios_true_onboarding_events_guid = (select $get_guid(`ReportEnvironment_Keys`, `ReportEnvironment_Values`) as guid, EventName as event, 'ios' as platform, AppID, AppBuildNumber, $makedate(EventTimestamp,0) as fielddate from $all_tables($appmetrika)
        WHERE APIKey = 2126725
        AND EventName IN ('onboarding start', 'onboarding interrupted', 'onboarding finish'));
        
$android_balloon_ok = (SELECT * from $android_balloon_ok_guid as l join $users as r using (guid));
$android_onboarding_events = (SELECT * FROM $android_onboarding_events_guid as l join $users as r using (guid));
$ios_onboarding_events = (SELECT * FROM $ios_onboarding_events_guid as l join $users as r using (guid));
$android_true_onboarding_events = (SELECT * FROM $android_true_onboarding_events_guid as l join $users as r using (guid));
$ios_true_onboarding_events = (SELECT * FROM $ios_true_onboarding_events_guid as l join $users as r using (guid));


$output = '//home/mssngr/squeeze/funnel_data/onboarding_event_tags_pre';
INSERT INTO $output WITH TRUNCATE 
SELECT * FROM $android_balloon_cancel
UNION ALL
SELECT * FROM $ios_balloon
UNION ALL
SELECT * FROM $android_balloon_ok
UNION ALL
SELECT * FROM $android_onboarding_events
UNION ALL
SELECT * FROM $ios_onboarding_events
UNION ALL
SELECT * FROM $android_true_onboarding_events
UNION ALL
SELECT * FROM $ios_true_onboarding_events;

COMMIT;
  

$input = '//home/mssngr/squeeze/funnel_data/onboarding_event_tags_pre';
$outtab = '//home/mssngr/squeeze/funnel_data/onboarding_event_tags';

INSERT INTO $outtab WITH TRUNCATE 
SELECT puid, MIN(fielddate), MIN_BY(is_balloon_ok_android, fielddate), MIN_BY(is_balloon_ok_ios, fielddate), MIN_BY(is_balloon_cancel_android, fielddate), MIN_BY(is_balloon_cancel_ios, fielddate), MIN_BY(balloon_shown_android, fielddate), MIN_BY(balloon_shown_ios, fielddate), MIN_BY(onboarding_started_android, fielddate), MIN_BY(onboarding_started_ios, fielddate), MIN_BY(onboarding_finished_android, fielddate), MIN_BY(onboarding_finished_ios, fielddate)
FROM
(SELECT 
    puid, 
    fielddate,
    BOOL_OR(IF(event = 'balloon_ok' and platform = 'android', true, false)) as is_balloon_ok_android,
    BOOL_OR(IF(event = 'balloon_ok' and platform = 'ios', true, false)) as is_balloon_ok_ios,
    BOOL_OR(IF(event = 'balloon_cancel' and platform = 'android', true, false)) as is_balloon_cancel_android,
    BOOL_OR(IF(event = 'balloon_cancel' and platform = 'ios', true, false)) as is_balloon_cancel_ios,
    BOOL_OR(IF((event = 'balloon_ok' OR event = 'balloon_cancel') and platform = 'android', true, false)) as balloon_shown_android,
    BOOL_OR(IF((event = 'balloon_ok' OR event = 'balloon_cancel') and platform = 'ios', true, false)) as balloon_shown_ios,
    BOOL_OR(IF(event = 'onboarding start' and platform = 'android', true, false)) as onboarding_started_android,
    BOOL_OR(IF(event = 'onboarding start' and platform = 'ios', true, false)) as onboarding_started_ios,
    BOOL_OR(IF(event = 'onboarding finished' and platform = 'android', true, false)) as onboarding_finished_android,
    BOOL_OR(IF(event = 'onboarding finish' and platform = 'ios', true, false)) as onboarding_finished_ios,
    -- BOOL_OR(IF(event = 'onboarding interrupted' and platform = 'android', true, false)) as onboarding_interrupted_android,
    -- BOOL_OR(IF(event = 'onboarding interrupted' and platform = 'ios', true, false)) as onboarding_interrupted_ios,
    -- BOOL_OR(IF(event = 'q_shown_Onboarding', true, false)) as onboarding_step_shown_ios,
    -- BOOL_OR(IF(event = 'q_shown_/onboarding', true, false)) as onboarding_step_shown_android,
    -- BOOL_OR(IF(event = 'q_tap_/onboarding/contacts/onboarding_submit_button', true, false)) as onboarding_step_contacts_submit_ios,
    -- BOOL_OR(IF(event = 'q_tap_Onboarding/Notifications/Next', true, false)) as onboarding_step_contacts_submit_android,
    -- BOOL_OR(IF(event = 'q_tap_/onboarding/push/onboarding_submit_button', true, false)) as onboarding_step_push_submit_android,
    -- BOOL_OR(IF(event = 'q_tap_Onboarding/Contacts/Next', true, false)) as onboarding_step_push_submit_ios
FROM $input
GROUP BY puid, fielddate )
GROUP BY puid
UNION ALL
SELECT * FROM $outtab
WHERE fielddate NOT IN $dates;
