use hahn;
PRAGMA yson.DisableStrict;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

DECLARE $day as String;
DECLARE $numdays as Integer;
$dates = ListMap(ListFromRange(0, $numdays), ($d) -> {
    RETURN DateTime::Format('%Y-%m-%d')(DateTime::MakeDate(DateTime::Parse('%Y-%m-%d')($day)) - $d * Interval('P1D')) ?? '';
});
$first_day = Unwrap($dates[ListLength($dates) - 1]);

DEFINE SUBQUERY $all_tables($path) AS
    SELECT * FROM RANGE($path, $first_day, $day);
END DEFINE;
$moscow_date = ($ts) -> {RETURN DateTime::Format("%Y-%m-%d")(DateTime::StartOfDay(AddTimezone(CAST($ts AS DateTime), 'Europe/Moscow')));};

$app_metrica_path = '//home/logfeller/logs/appmetrica-yandex-events/1d';

$outtab = '//home/mssngr/squeeze/funnel_data/onboard';

INSERT INTO  $outtab WITH TRUNCATE 
SELECT EventName, CAST(APIKey as STRING) as APIKey,AppID, guid, MAX(fielddate) as fielddate
FROM
(SELECT DateTime::MakeDate(DateTime::FromSeconds(CAST(EventTimestamp as Uint32))) as fielddate,EventName, APIKey,AppID, ReportEnvironment_Values[ListIndexOf(ReportEnvironment_Keys, 'guid')] as guid
FROM $all_tables($app_metrica_path)
WHERE ((APIKey = 2126725 and AppID = 'ru.yandex.mobile') or (APIKey = 1630031 and AppID ='ru.yandex.searchplugin')) and EventName in ('onboarding finish','onboarding finished')
--and AccountID is not NULL and AccountID != '0' and AccountID!= ''
)
GROUP BY guid, EventName, APIKey,AppID
UNION ALL
SELECT * FROM $outtab
WHERE DateTime::Format("%Y-%m-%d")(fielddate) NOT IN $dates
;
