--10321 - android
--42989 - ios

use hahn;
PRAGMA yson.DisableStrict;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

DECLARE $day as String;
DECLARE $numdays as Integer;
$dates = ListMap(ListFromRange(0, $numdays), ($d) -> {
    RETURN DateTime::Format('%Y-%m-%d')(DateTime::MakeDate(DateTime::Parse('%Y-%m-%d')($day)) - $d * Interval('P1D')) ?? '';
});
$first_day = Unwrap($dates[ListLength($dates) - 1]);

$makedate = ($ts, $j) ->{
 $res = DateTime::Format('%Y-%m-%d')(IF($j=0,DateTime::FromSeconds(CAST($ts as Uint32)), DateTime::FromMicroseconds(CAST($ts as Uint64))));
 RETURN ($res)
};



DEFINE SUBQUERY $all_tables($path) AS
    SELECT * FROM RANGE($path, $first_day, $day);
END DEFINE;
-- $moscow_date = ($ts) -> {RETURN DateTime::Format("%Y-%m-%d")(DateTime::StartOfDay(AddTimezone(CAST($ts AS DateTime), 'Europe/Moscow')));};

$app_metrica_path = '//home/logfeller/logs/superapp-metrika-mobile-log/1d';

-- $outtab = '//home/socialmetrics/tmp/PA-947/pp_users';

$all_data = (SELECT $makedate(EventTimestamp,0) as fielddate, AccountID as puid, CAST(APIKey as STRING) as APIKey
FROM $all_tables($app_metrica_path)
WHERE APIKey in (42989, 10321) and AccountID is not NULL and AccountID != '0' AND SessionType IS NULL);

$outtab = '//home/mssngr/squeeze/funnel_data/pp_users';
INSERT INTO $outtab WITH TRUNCATE 
SELECT DISTINCT fielddate,puid, APIKey
FROM $all_data
UNION ALL
SELECT * FROM $outtab
WHERE fielddate NOT IN $dates;
