use hahn;
PRAGMA yt.InferSchema = '1000';

DECLARE $day as String;
$path = '//home/mssngr/squeeze/funnel_data/';
$pp_users = $path || 'pp_users';
$onb_users = $path || 'onboard';
$sent = $path ||  'first_stats_messages_all';
$was_in_mssngr = $path || 'metrica_users';
$app_metrica_users = $path || 'app_metrica_users_q_and_chat';
$onb_data = $path || 'onboarding_event_tags';

$users_table = '//home/mssngr/private/current_state/users/'||$day;
$guid_puid = (select guid, puid from $users_table);

$result =  $path || 'result_onboarded_all';

$date_from_day = ($day)->{RETURN (DateTime::MakeDate(DateTime::Parse('%Y-%m-%d')($day)))};

$onboarded_guid_puid=
(SELECT SOME(guid) as guid, MIN(fielddate) as fielddate, puid
FROM
(SELECT a.guid as guid, a.fielddate as fielddate, CAST(b.puid as String) as puid
FROM $onb_users as a
LEFT JOIN $guid_puid as b
ON a.guid = b.guid)
GROUP BY puid);

$pp_and_metrica =
(SELECT a.puid as puid, a.APIKey as APIKey, a.fielddate as fielddate, b.counterid as counterid
FROM $pp_users as a
LEFT JOIN $was_in_mssngr as b
ON a.puid = b.puid and a.fielddate=b.fielddate
)
;



$pp_and_metrica_and_appmetrica =
(SELECT a.puid as puid, a.APIKey as APIKey, a.fielddate as fielddate, a.counterid as counterid, b.APIKey as pp_metrica
FROM $pp_and_metrica as a
LEFT JOIN $app_metrica_users as b
ON a.puid = CAST(b.puid as String) and a.fielddate=b.fielddate
);

$pp_and_onboard =
(SELECT a.puid as puid, a.APIKey as APIKey, b.guid as guid, $date_from_day(a.fielddate) as fielddate, b.fielddate as onboardfinish_date, $date_from_day(a.fielddate) >= (b.fielddate ?? $date_from_day('2021-01-01'))  as onboarded, a.counterid as counterid, a.pp_metrica as pp_metrica
FROM $pp_and_metrica_and_appmetrica as a
LEFT JOIN $onboarded_guid_puid as b
ON a.puid = b.puid
);



$all_data = 
(
SELECT a.puid as puid, a.APIKey as APIKey, a.guid as guid, a.fielddate as fielddate, a.onboardfinish_date as onboardfinish_date, a.onboarded as onboarded, a.counterid as counterid, a.pp_metrica as pp_metrica, b.balloon_shown_android as balloon_shown_android, b.balloon_shown_ios as balloon_shown_ios, b.is_balloon_ok_ios as is_balloon_ok_ios, b.is_balloon_ok_android as is_balloon_ok_android
FROM $pp_and_onboard as a
LEFT JOIN $onb_data as b
ON a.fielddate = $date_from_day(b.fielddate) and a.puid = CAST(b.puid ?? 0 as String)
);

INSERT INTO $result WITH TRUNCATE 
SELECT a.puid as puid, CASE WHEN a.APIKey = '10321' THEN 'Android' ELSE 'IOS' END as platform, a.fielddate as fielddate, a.onboarded as onboarded, b.guid as guid, a.counterid as counterid, a.pp_metrica as pp_metrica, a.balloon_shown_android as balloon_shown_android, a.balloon_shown_ios as balloon_shown_ios, a.is_balloon_ok_ios as is_balloon_ok_ios, a.is_balloon_ok_android as is_balloon_ok_android
FROM $all_data as a
LEFT JOIN (SELECT DISTINCT puid, fielddate, guid FROM $sent) as b
ON a.puid = CAST(b.puid as String) and a.fielddate = $date_from_day(b.fielddate);
