use hahn;
PRAGMA yson.DisableStrict;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

DECLARE $day as String;
DECLARE $numdays as Integer;
$dates = ListMap(ListFromRange(0, $numdays), ($d) -> {
    RETURN DateTime::Format('%Y-%m-%d')(DateTime::MakeDate(DateTime::Parse('%Y-%m-%d')($day)) - $d * Interval('P1D')) ?? '';
});
$first_day = Unwrap($dates[ListLength($dates) - 1]);

DEFINE SUBQUERY $all_tables($path) AS
    SELECT * FROM RANGE($path, $first_day, $day);
END DEFINE;
$moscow_date = ($ts) -> {RETURN DateTime::Format("%Y-%m-%d")(DateTime::StartOfDay(AddTimezone(CAST($ts AS DateTime), 'Europe/Moscow')));};

$web_metrica_path = '//logs/bs-watch-log/1d';
$app_metrica_path = '//home/logfeller/logs/appmetrica-yandex-events/1d';

$users_table = '//home/mssngr/private/current_state/users/'||$day;
$guid_puid = (select guid, puid from $users_table);

$makedate = ($ts, $j) ->{
 $res = DateTime::Format('%Y-%m-%d')(IF($j=0,DateTime::FromSeconds(CAST($ts as Uint32)), DateTime::FromMicroseconds(CAST($ts as Uint64))));
 RETURN ($res)
};


--('48256454','52122583')
DEFINE SUBQUERY $mssng_metrica_users() as
SELECT DISTINCT fielddate, passportuid as puid, counterid
FROM
(SELECT $makedate(eventtime,0) as fielddate, passportuid, counterid
FROM $all_tables($web_metrica_path)
WHERE counterid in ('48256454') and passportuid != '0' and passportuid is not NULL
-- (Yson::LookupString(Yson::ParseJson(params), 'chatId') LIKE '0/%') as chat_0
);
END DEFINE;

-- $get_value_from_data_old = ($keys,$values,$key)->{
-- RETURN (Yson::LookupString(Yson::ParseJson($values), COALESCE(CAST(Listindexof(Yson::ConvertToStringList(Yson::ParseJson($keys)), $key) as STRING), '')) )
-- };

$get_value_from_data = ($keys,$values,$key)->{
RETURN $values[ListIndexOf($keys, $key)]
};



DEFINE SUBQUERY $mssng_appmetrica_users() as
SELECT DISTINCT fielddate, guid, APIKey
FROM
(SELECT $makedate(EventTimestamp,0) as fielddate, $get_value_from_data(ReportEnvironment_Keys,ReportEnvironment_Values,'guid') as guid, APIKey
FROM $all_tables($app_metrica_path)
WHERE (APIKey = 1630031 and EventName in ('chatlist opened','chat opened') ) or  (APIKey = 2126725 and EventName = 'q_shown' and Yson::LookupString(Yson::ParseJson(EventValue), 'path') in ('Chat','ChatList') )
);
END DEFINE;

$app_metrica_users = '//home/mssngr/squeeze/funnel_data/app_metrica_users_q_and_chat';
$metrica_users = '//home/mssngr/squeeze/funnel_data/metrica_users';

INSERT INTO $metrica_users WITH TRUNCATE 
SELECT * FROM $mssng_metrica_users()
UNION ALL
SELECT * FROM $metrica_users
WHERE fielddate NOT IN $dates
;


INSERT INTO $app_metrica_users WITH TRUNCATE 
SELECT a.fielddate as fielddate, a.guid as  guid, b.puid as puid, CAST(a.APIKey as STRING) as APIKey 
FROM $mssng_appmetrica_users() as a
LEFT JOIN $guid_puid as b
ON a.guid = b.guid
WHERE puid is not null
UNION ALL
SELECT * FROM $app_metrica_users
WHERE fielddate NOT IN $dates;
