USE hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yson.DisableStrict;
PRAGMA yt.TemporaryAutoMerge = 'disabled';
pragma yt.Pool = 'portalytics-adhocs';

$day = CurrentUtcDate()- Interval("P1D");
$numdays = 3;

$end_date = CAST($day as DATE);
$start_date = $end_date - Interval("P1D")*($numdays-1);

$dates = ListMap(ListFromRange(0, $numdays), ($d) -> {
    RETURN Cast($day AS Date) - $d * Interval('P1D');
});

$moscow_date = ($eventtime) -> {
   RETURN CAST(CAST($eventtime + 3600 * 3 AS DateTime) AS Date)
};

-- Новые отправки
$new = SELECT TableName() as send_day, transit_id, app_name as AppID, platform, String::RemoveAll(device, '-') as device_id FROM RANGE(`//home/logfeller/logs/xivahub-log/1d`, CAST($start_date as String), CAST($end_date as String))
WHERE status = 'conveyed' AND service = 'yamb' AND app_name in ['com.yandex.alicekit.demo', 'com.yandex.browser', 'com.yandex.browser.alpha', 'com.yandex.browser.beta', 'com.yandex.yamb', 'com.yandex.yamb.canary', 'ru.yandex.searchplugin', 'ru.yandex.searchplugin.beta'];


INSERT INTO `//home/portalytics/alramazanov/push_messenger/all_new/sent` WITH TRUNCATE 
SELECT * from $new
union all
SELECT * from `//home/portalytics/alramazanov/push_messenger/all_new/sent`
WHERE CAST(send_day as DATE) not in $dates;

-- Новые доставки

EVALUATE FOR $d in $dates DO BEGIN
INSERT INTO @new_delivered 
SELECT TableName() as table_name, $moscow_date(CAST(EventTimestamp as Int32)) as delivered_day, DeviceID as device_id, EventName, AppID, Manufacturer, Model, _logfeller_icookie as icookie, Yson::ConvertToStringDict(Yson::ParseJson(EventValue))['transit_id'] as transit_id FROM RANGE(`//logs/appmetrica-yandex-events/1d`, CAST($d as String), CAST($d as String))
where APIKey in [1630031, 3071014] and EventName in ('notification_show', 'notification_not_show', 'notification_update_error', 'push_received', 'push_error');
COMMIT;
END DO;

INSERT INTO `//home/portalytics/alramazanov/push_messenger/all_new/delivered` WITH TRUNCATE
SELECT * from `//home/portalytics/alramazanov/push_messenger/all_new/delivered`
WHERE CAST(table_name as DATE) NOT IN $dates
UNION ALL
SELECT * FROM @new_delivered;

--дашборд

COMMIT;

$sent = SELECT * FROM `//home/portalytics/alramazanov/push_messenger/all_new/sent`
WHERE transit_id is not NULL;

$delivered = SELECT * FROM `//home/portalytics/alramazanov/push_messenger/all_new/delivered`
WHERE transit_id is not NULL;

$delivered = SELECT MIN(delivered_day) as delivered_day, 1 as delivered, AppID, SOME(Manufacturer) as Manufacturer, transit_id, device_id, SOME(icookie) as icookie from $delivered
GROUP BY AppID, transit_id, device_id;

$device_id_man = SELECT * FROM `//home/portalytics/alramazanov/1267/devid_man`;

$device_id_man = SELECT device_id, column1[0].Value as Manufacturer, icookie[0].Value as icookie FROM $device_id_man;

$sent_delivered = SELECT * from 
$sent as a
left join
$delivered as b
using(transit_id, device_id, AppID);

$sent_delivered = SELECT AppID, platform, a.Manufacturer ?? b.Manufacturer as Manufacturer, a.icookie ?? b.icookie as icookie, delivered ?? 0 as delivered, CAST(send_day as DATE) as sent_day, delivered_day, a.device_id as device_id, transit_id from 
$sent_delivered as a 
left join
$device_id_man as b
using(device_id);

INSERT INTO `//home/portalytics/alramazanov/push_messenger/all_new/dashboard` WITH TRUNCATE 
SELECT sent_day as day, platform, AppID, Manufacturer, COUNT_IF(delivered == 0) as not_delivered, COUNT_IF(delivered == 1) as delivered, COUNT(*) as sent 
from $sent_delivered
WHERE icookie is not null
GROUP BY sent_day, AppID, Manufacturer, platform;

COMMIT;


INSERT INTO `//home/portalytics/alramazanov/push_messenger/all_new/popular_manufacturer` WITH TRUNCATE 
SELECT Manufacturer, SUM(sent) as sent, SUM(delivered) as delivered, SUM(not_delivered) as not_delivered, CAST(SUM(not_delivered) as Double)/CAST(SUM(sent) as Double) as part_not_delivered from `//home/portalytics/alramazanov/push_messenger/all_new/dashboard` 
WHERE CAST(day as Date) > CurrentUtcDate() - Interval("P15D") 
GROUP BY Manufacturer
ORDER BY sent DESC
limit 30;
