use hahn;

DECLARE $day as String;
DECLARE $numdays as Integer;
DECLARE $scale as STRING;
$scale = IF ($scale IS NULL OR $scale NOT IN ('wau', 'mau'), 'dau', $scale);


$scale_date = ($date, $scale) -> {RETURN
CASE $scale
    WHEN 'wau' THEN CAST(DateTime::MakeDate(DateTime::StartOfWeek(CAST($date as Date))) as STRING)
    WHEN 'mau' THEN CAST(DateTime::MakeDate(DateTime::StartOfMonth(CAST($date as Date))) as STRING)
    ELSE $date
END};


$first_day = DateTime::Format('%Y-%m-%d')(DateTime::MakeDate(DateTime::Parse('%Y-%m-%d')($day)) - $numdays * Interval('P1D'));

$outtab = '//home/mssngr/squeeze/dashboard_datasets/readers_'||$scale;

$clean_data = (SELECT DISTINCT guid,chat_id,chat_type FROM
    RANGE("//home/mssngr/squeeze/seen_markers", $first_day, $day)
    WHERE
    to_count
    AND origin !=0
    AND NOT is_tester
    AND NOT is_robot
    AND NOT from_robot
    AND NOT is_team
    AND NOT is_connect
    AND NOT is_public_banned
    AND NOT is_private_banned
    AND (chat_type = '1on1' OR chat_id LIKE '0/0/%'));
    

$chats_data = (SELECT DISTINCT $day as fielddate,chat_id,chat_type FROM $clean_data);
$guid_data = (SELECT DISTINCT $day as fielddate,guid,chat_type FROM $clean_data);

INSERT INTO $outtab 
SELECT a.fielddate as fielddate, a.users_read as users_read, a.private_users_read as private_users_read, a.group_users_read as group_users_read, 
b.chats_with_seen_msgs as chats_with_seen_msgs, b.private_chats_with_seen_msgs as private_chats_with_seen_msgs, b.group_chats_with_seen_msgs as group_chats_with_seen_msgs
FROM
(SELECT fielddate, COUNT(DISTINCT guid)  as users_read, COUNT(DISTINCT IF( chat_type = '1on1', guid, NULL)) as private_users_read, COUNT(DISTINCT IF(chat_type != '1on1', guid, NULL)) as group_users_read
FROM $guid_data 
GROUP BY fielddate) as a
LEFT JOIN
(SELECT fielddate, COUNT(DISTINCT chat_id)  as chats_with_seen_msgs, COUNT(DISTINCT IF( chat_type = '1on1', chat_id, NULL)) as private_chats_with_seen_msgs, COUNT(DISTINCT IF(chat_type != '1on1', chat_id, NULL)) as group_chats_with_seen_msgs
FROM $chats_data 
GROUP BY fielddate) as b
ON a.fielddate = b.fielddate;
