DECLARE $day as String;
USE hahn;

PRAGMA Library('messenger_lib.sql');
IMPORT messenger_lib SYMBOLS $default_filter;

$ts_5_min = CAST(1000000 as UINT64)*60*5;
$ts_1_hour = CAST(1000000 as UINT64)*60*60;
$ts_1_day = CAST(1000000 as UINT64)*60*60*24;
$ts_2_day = CAST(1000000 as UINT64)*60*60*24*2;
$ts_7_days = CAST(1000000 as UINT64)*60*60*24*7;

$start_date = DateTime::Format('%Y-%m-%d')(DateTime::MakeDate(DateTime::Parse('%Y-%m-%d')($day)) - 6 * Interval('P1D'));;

$sent_messages = (
select 
    guid as sender,
    chat_id,
    msg_timestamp,
    is_robot as from_support,
    fielddate
from RANGE(`//home/mssngr/squeeze/sent_messages`, $start_date, $day)
WHERE
    event_subtype = "sending"
    AND to_count 
    AND (NOT is_robot or guid IN (SELECT guid as guid FROM `//home/mssngr/private/current_state/support_bots`))
    AND NOT to_robot
    AND NOT is_tester
    AND NOT is_team
    AND NOT is_connect
    AND NOT is_public_banned
    AND NOT is_private_banned
    AND chat_id != guid || '_' || guid
    AND chat_type = '1on1');
    
$seen_markers = (
select 
    guid as reciever,
    chat_id,
    event_timestamp
from RANGE(`//home/mssngr/squeeze/seen_markers`, $start_date, $day)
WHERE chat_type = '1on1' AND origin !=0);
    
$joined = (SELECT sender, reciever, from_support, l.chat_id as chat_id, msg_timestamp, event_timestamp, fielddate
from $sent_messages as l
left join $seen_markers as r
using (chat_id));

$reads = (select msg_timestamp, chat_id, from_support, MIN(event_timestamp) - msg_timestamp ?? $ts_7_days as time_diff, fielddate from $joined 
where 
    (sender != reciever or reciever is null)
    and (msg_timestamp < event_timestamp OR event_timestamp is NULL)
group by msg_timestamp, chat_id, fielddate, from_support);
    
INSERT INTO  `//home/mssngr/squeeze/dashboard_datasets/reading_time` 
select COUNT(DISTINCT chat_id) as chats,
COUNT(DISTINCT read_chat_id) as chats_reads,
COUNT(DISTINCT chat_id_5_min) as chats_5_min,
COUNT(DISTINCT chat_id_1_hour) as chats_1_hour,
COUNT(DISTINCT chat_id_1_day) as chats_1_day,
COUNT(DISTINCT chat_id_2_day) as chat_id_2_day,
COUNT(DISTINCT chat_id_7_days) as chats_7_days,
100.0*COUNT(DISTINCT read_chat_id)/COUNT(DISTINCT chat_id) as chats_reads_percent,
100.0*COUNT(DISTINCT chat_id_5_min)/COUNT(DISTINCT chat_id) as chats_5_min_percent,
100.0*COUNT(DISTINCT chat_id_1_hour)/COUNT(DISTINCT chat_id) as chats_1_hour_percent,
100.0*COUNT(DISTINCT chat_id_1_day)/COUNT(DISTINCT chat_id) as chats_1_day_percent,
100.0*COUNT(DISTINCT chat_id_2_day)/COUNT(DISTINCT chat_id) as chats_2_day_percent,
100.0*COUNT(DISTINCT chat_id_7_days)/COUNT(DISTINCT chat_id) as chats_7_days_percent,
fielddate, from_support from (
    select
        chat_id,
        IF(MAX(time_diff) IS NOT NULL, chat_id, NULL) as read_chat_id,
        IF(MAX(time_diff) < $ts_5_min, chat_id, NULL) as chat_id_5_min,
        IF(MAX(time_diff) < $ts_1_hour, chat_id, NULL) as chat_id_1_hour,
        IF(MAX(time_diff) < $ts_1_day, chat_id, NULL) as chat_id_1_day,
        IF(MAX(time_diff) < $ts_2_day, chat_id, NULL) as chat_id_2_day,
        IF(MAX(time_diff) < $ts_7_days, chat_id, NULL) as chat_id_7_days,
        $day as fielddate,
        from_support
    from $reads
    group by chat_id, from_support)
group by fielddate, from_support;
