use hahn;
DECLARE $day AS String;
$date = $day;
$output_prefix = '//home/mssngr/squeeze';
$output_daily_folder = $output_prefix||'/reports';
$output_daily = $output_daily_folder||'/'||$date;
-- $output_total = $output_prefix||'/data/reports_all';
$output_graph = $output_prefix||'/dashboard_datasets/reports';
$input = '//home/logfeller/logs/mssngr-router-event-log/1d/'||$date;

insert into $output_daily WITH TRUNCATE 
select Guid as guid, `Timestamp` as `timestamp`, ToGuid as to_guid, ChatId as chat_id, $date as fielddate, iso_eventtime
from $input
WHERE event_name = 'TReportInfo';
COMMIT;

-- INSERT INTO $output_total WITH TRUNCATE
-- SELECT * FROM RANGE($output_daily_folder)
-- UNION ALL
-- SELECT * FROM $output_daily;
-- COMMIT;

INSERT INTO $output_graph WITH TRUNCATE
SELECT 
    fielddate,
    COUNT(DISTINCT guid) as reporters,
    COUNT(*) as reports,
    COUNT_IF(`timestamp` != 0) as msgs_reported,
    COUNT(DISTINCT chat_reported) as chats_reported,
    COUNT(DISTINCT to_guid) as users_reported
FROM 
    (select 
        fielddate,
        guid,
        to_guid,
        `timestamp`,
        IF(`timestamp` = 0, chat_id, NULL) as chat_reported
    from
        $output_daily
    WHERE 
        chat_id IS NULL OR
        chat_id LIKE '0/0/%' OR
        (chat_id NOT LIKE '0/%' and chat_id NOT LIKE '1/%')
    )
GROUP BY fielddate
UNION ALL
SELECT * FROM $output_graph
WHERE fielddate != $date
