-- Пользователи, отправляющие сообщения в чатах 1 на 1 и приватных групповых
-- в разбивке по "возрасту"

USE hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yt.TemporaryAutoMerge = "disabled";
PRAGMA Library("messenger_lib.sql");

IMPORT messenger_lib SYMBOLS $default_filter;

$one_on_one_filter = ($row) -> ($default_filter($row) AND NOT $row.to_robot AND
    ($row.chat_type = "1on1" OR $row.chat_id LIKE "0/0/%"));
    
$source = SELECT *
FROM Range(`//home/mssngr/squeeze/sent_messages`, `2020-04-19`);


$first_dates = SELECT guid, CAST(MIN(fielddate) AS Date) AS first_date
FROM $source
WHERE $one_on_one_filter(TableRow())
GROUP BY guid;


$stats = SELECT
    fielddate,
    age,
    COUNT(*) AS cnt
FROM (
    SELECT DISTINCT
        fielddate,
        guid
    FROM $source
    WHERE $one_on_one_filter(TableRow())
) AS a
JOIN ANY $first_dates AS b
USING(guid)
GROUP BY
    CAST(a.fielddate AS Date) AS fielddate,
    DateTime::ToDays(CAST(a.fielddate AS Date) - b.first_date) AS age;
    

INSERT INTO `//home/mssngr/squeeze/dashboard_datasets/retention_stats` WITH TRUNCATE
SELECT * FROM $stats
ORDER BY fielddate, age;
