USE hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yt.TemporaryAutoMerge = "disabled";
PRAGMA Library("messenger_lib.sql");

IMPORT messenger_lib SYMBOLS $default_filter;

$one_on_one_filter = ($row) -> ($default_filter($row) AND NOT $row.to_robot AND
    ($row.chat_type = "1on1" OR $row.chat_id LIKE "0/0/%"));

$source = SELECT *
FROM Range(`//home/mssngr/squeeze/sent_messages`, `2020-04-19`);


$all_dates = SELECT DISTINCT
    guid,
    CAST(fielddate AS Date) AS day
FROM $source
WHERE $one_on_one_filter(TableRow());

$extreme_dates = SELECT
    guid,
    MIN(day) AS first_day,
    MAX(day) AS last_day
FROM $all_dates
GROUP BY guid;


$stats = SELECT 
    a.guid AS guid,
    first_day,
    last_day,
    day
FROM $all_dates AS a
JOIN ANY $extreme_dates AS b
USING(guid);
    

INSERT INTO `//home/mssngr/squeeze/dashboard_datasets/all_senders_dates` WITH TRUNCATE
SELECT * FROM $stats
ORDER BY guid, day;
