use hahn;

PRAGMA Library('messenger_lib.sql');
IMPORT messenger_lib SYMBOLS $Russian_origin;

DECLARE $scale as STRING;
$scale = IF ($scale NOT IN ('wau', 'mau'), 'dau', $scale);


$scale_date = ($date, $scale) -> {RETURN
CASE $scale
    WHEN 'wau' THEN CAST(DateTime::MakeDate(DateTime::StartOfWeek(CAST($date as Date))) as STRING)
    WHEN 'mau' THEN CAST(DateTime::MakeDate(DateTime::StartOfMonth(CAST($date as Date))) as STRING)
    ELSE $date
END};

$to_bot = 
SELECT * FROM
(SELECT fielddate, guid, to_guid, chat_id, origin FROM RANGE('//home/mssngr/squeeze/sent_messages')
where 
    event_subtype = "sending"
    AND to_count 
    AND NOT is_robot
    -- AND NOT to_robot
    AND NOT is_tester
    AND NOT is_team
    AND NOT is_connect
    AND NOT is_public_banned
    AND NOT is_private_banned) as l
JOIN (SELECT guid as to_guid, service FROM `//home/mssngr/private/current_state/support_bots`) as r
USING (to_guid);

$from_bot = 
SELECT * FROM
(SELECT fielddate, guid, from_guid, chat_id, origin FROM RANGE('//home/mssngr/squeeze/seen_markers')) as l
JOIN (SELECT guid as from_guid, service FROM `//home/mssngr/private/current_state/support_bots`) as r
USING (from_guid);


$output_writers = '//home/mssngr/squeeze/dashboard_datasets/support_bot_writers_'||$scale;
INSERT INTO $output_writers
SELECT fielddate, COUNT(*) as msgs, COUNT(DISTINCT chat_id) as chats, COUNT(DISTINCT to_guid) as bots, service, origin, service??'ALL' as service_, $Russian_origin(origin, FALSE)??'ALL' as origin_, COUNT(DISTINCT guid) as users
FROM $to_bot
GROUP BY CUBE(origin), CUBE(service), $scale_date(fielddate, $scale) as fielddate;

$output_reader = '//home/mssngr/squeeze/dashboard_datasets/support_bot_readers_'||$scale;
INSERT INTO $output_reader
SELECT fielddate, COUNT(DISTINCT chat_id) as chats, COUNT(DISTINCT from_guid) as bots, service, origin, service??'ALL' as service_, $Russian_origin(origin, FALSE)??'ALL' as origin_, COUNT(DISTINCT guid) as users
FROM $from_bot
GROUP BY CUBE(origin), CUBE(service), $scale_date(fielddate, $scale) as fielddate;
