USE hahn;
PRAGMA Library('messenger_lib.sql');

IMPORT messenger_lib SYMBOLS $default_filter;

DECLARE $day AS String;
DECLARE $numdays AS Integer;

$dates = ListMap(ListFromRange(0, $numdays), ($d) -> {
    RETURN DateTime::Format('%Y-%m-%d')(DateTime::MakeDate(DateTime::Parse('%Y-%m-%d')($day)) - $d * Interval('P1D')) ?? '';
});

$first_day = Unwrap($dates[ListLength($dates) - 1]);

DEFINE SUBQUERY $all_tables($path) AS
    SELECT * FROM RANGE($path, $first_day, $day);
END DEFINE;


$source = SELECT 
    fielddate,
    guid,
    IF(payload_type = 8, guid) AS guid_voice
FROM $all_tables("//home/mssngr/squeeze/sent_messages")
WHERE
    $default_filter(TableRow())
    AND (chat_type = '1on1' OR chat_id LIKE '0/0/%');


$output_table = "//home/mssngr/squeeze/dashboard_datasets/voice_stats";

INSERT INTO $output_table WITH TRUNCATE 
SELECT 
    fielddate,
    Count(*) AS messages_total,
    CountDistinctEstimate(guid) AS users_total,
    COUNT_IF(guid_voice IS NOT NULL) AS messages_voice,
    COUNT(DISTINCT guid_voice) AS users_voice
FROM $source
GROUP BY fielddate
UNION ALL
SELECT * FROM $output_table
WHERE fielddate NOT IN $dates;
