use hahn;
PRAGMA yson.DisableStrict;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yt.InferSchema = '1';

DECLARE $day as String;
DECLARE $numdays as Integer;

$tab = "//home/mssngr/private/chats";
$seen_tab = "//home/mssngr/squeeze/seen_markers";

$res_tab1 = "//home/mssngr/squeeze/zen_data/n_chats";
$res_tab2 = "//home/mssngr/squeeze/zen_data/n_chats_seen";


$dates = ListMap(ListFromRange(0, $numdays), ($d) -> {
    RETURN DateTime::Format('%Y-%m-%d')(DateTime::MakeDate(DateTime::Parse('%Y-%m-%d')($day)) - $d * Interval('P1D')) ?? '';
});
$first_day = Unwrap($dates[ListLength($dates) - 1]);

DEFINE SUBQUERY $all_tables_nchats($path) AS
    SELECT * FROM RANGE($path, '2010-10-01', $day);
END DEFINE;

DEFINE SUBQUERY $all_tables($path) AS
    SELECT * FROM RANGE($path, $first_day, $day);
END DEFINE;


$makedate = ($ts, $j) ->{
 $res = DateTime::Format('%Y-%m-%d')(IF($j=0,DateTime::FromSeconds(CAST($ts as Uint32)), DateTime::FromMicroseconds(CAST($ts as Uint64))));
 RETURN ($res)
};

DEFINE SUBQUERY $all_data() AS
    SELECT fielddate, SOME(create_timestamp) as order_ts, namespace, COUNT(DISTINCT chat_id) as n_chats
    FROM 
       (SELECT create_timestamp, $makedate(create_timestamp,1) as fielddate,namespace,chat_id FROM  $all_tables_nchats($tab) )
    WHERE namespace=12
    GROUP BY fielddate,namespace;
END DEFINE;

INSERT INTO $res_tab1 WITH TRUNCATE 
SELECT *
FROM 
(SELECT fielddate,order_ts,namespace, n_chats, SUM(n_chats) OVER w AS cum_n_chats
FROM $all_data()
WINDOW w AS ( 
    PARTITION BY namespace 
    ORDER BY order_ts   
)
ORDER BY order_ts)
WHERE fielddate in $dates
UNION ALL
SELECT * FROM $res_tab1
WHERE fielddate not in $dates
;

INSERT INTO $res_tab2 WITH TRUNCATE 
SELECT fielddate, namespace, COUNT(DISTINCT guid) as n_users, COUNT(DISTINCT chat_id) as n_chats
FROM
(SELECT fielddate, namespace, chat_id, guid
FROM $all_tables($seen_tab)
)
WHERE namespace=12 and fielddate in $dates
GROUP BY fielddate, namespace
UNION ALL
SELECT * FROM $res_tab2
WHERE fielddate not in $dates
;





