use hahn;
PRAGMA yt.InferSchema = '1';


$tab = "//home/mssngr/private/chats";
$seen_tab = "//home/mssngr/squeeze/seen_markers";
$sent_messages = "//home/mssngr/squeeze/sent_messages";
$allreadtop = "//home/mssngr/squeeze/zen_data/all_read_top";
$allmssgtop = "//home/mssngr/squeeze/zen_data/all_mssg_top";
$allwritetop = "//home/mssngr/squeeze/zen_data/all_write_top";
$allmpu_top = "//home/mssngr/squeeze/zen_data/all_mpu_top";

-- $weekreadtop = "//home/mssngr/squeeze/zen_data/week_read_top";
-- $weekmssgtop = "//home/mssngr/squeeze/zen_data/week_mssg_top";
-- $weekwritetop = "//home/mssngr/squeeze/zen_data/week_write_top";

$makedate = ($ts, $j) ->{
 $res = DateTime::Format('%Y-%m-%d')(IF($j=0,DateTime::FromSeconds(CAST($ts as Uint32)), DateTime::FromMicroseconds(CAST($ts as Uint64))));
 RETURN ($res)
};

$seen_chats = 
(SELECT COUNT(DISTINCT guid) as n_seen_users, chat_id
FROM RANGE($seen_tab,'2020-10-01')  
WHERE namespace=12
GROUP BY chat_id);

$chats =
(SELECT COUNT(DISTINCT msg_timestamp) as n_mssgs, COUNT(DISTINCT guid) as n_users, chat_id
FROM RANGE($sent_messages,'2020-10-01')  
WHERE namespace=12
GROUP BY chat_id);


INSERT INTO @all_data WITH TRUNCATE 
SELECT DISTINCT a.chat_id as chat_id, a.name as name, a.n_mssgs as n_mssgs, a.n_users as n_users, b.n_seen_users as n_seen_users, ( CAST(a.n_mssgs as DOUBLE )/a.n_users) ?? 0 as mssgs_per_user
FROM
(SELECT  a.chat_id as chat_id, a.name as name, b.n_mssgs as n_mssgs, b.n_users as n_users
FROM 
(SELECT chat_id, SOME(name) as name
FROM RANGE($tab,'2020-10-01')
WHERE namespace=12
GROUP BY chat_id) as a
LEFT JOIN
$chats as b
ON a.chat_id = b.chat_id) as a
LEFT JOIN $seen_chats as b
ON a.chat_id = b.chat_id

;

COMMIT;

INSERT INTO $allreadtop WITH TRUNCATE 
SELECT * FROM @all_data
ORDER BY n_seen_users DESC 
LIMIT 100;

INSERT INTO $allmssgtop WITH TRUNCATE 
SELECT * FROM @all_data
ORDER BY n_mssgs DESC 
LIMIT 100;

INSERT INTO $allwritetop WITH TRUNCATE 
SELECT * FROM @all_data
ORDER BY n_users DESC 
LIMIT 100;

INSERT INTO $allmpu_top WITH TRUNCATE 
SELECT * FROM @all_data
ORDER BY mssgs_per_user DESC 
LIMIT 100;

