$origin_names = {
    0: ('UNSET', 'Не задано'),
    1: ('SERVICES', 'Услуги'),
    2: ('SERP', 'Серп'),
    3: ('LOCAL', 'Район'),
    4: ('ETHER', 'Эфир'),
    5: ('IOS_SEARCHAPP', 'iOS ПП'),
    6: ('IOS_BROWSER', 'iOS Браузер'),
    7: ('IOS_STANDALONE', 'iOS Standalone'),
    8: ('BRINGLY', 'Bringly'),
    9: ('BERU', 'Beru'),
    10: ('MORDA', 'Морда'),
    11: ('WIDGET_ON_WEBSITE', 'Виджеты на сайтах'),
    12: ('MARKET', 'Маркет'),
    13: ('MAP', 'Карты'),
    14: ('TRAVEL', 'Travel'),
    15: ('DIRECT', 'Директ'),
    16: ('GEO', 'Гео'),
    17: ('ANDROID', 'Android (deprecated)'),
    18: ('COLLECTIONS', 'Коллекции'),
    19: ('HEALTH', 'Здоровье'),
    20: ('LMS', 'Лицей'),
    21: ('AURA', 'Аура'),
    22: ('TALENTS', 'Таланты'),
    23: ('TURBO_LANDING_CONSTRUCTOR', 'Конструктор лендингов в Турбо'),
    24: ('ANDROID_SEARCHAPP', 'Android ПП'),
    25: ('ANDROID_BROWSER', 'Android Браузер'),
    26: ('ANDROID_STANDALONE', 'Android Standalone'),
    27: ('WEB', ''),
    28: ('ELECTRON_APP', 'Web Standalone'),
    29: ('CMNT', 'Комментатор'),
    30: ('DESKTOP_YABRO', 'Десктопный браузер'),
    31: ('NMAP', 'Народные карты'),
    32: ('VIDEO', 'Видео'),
    33: ('YASTATION', 'Яндекс.Станция'),
    34: ('YASTATION_MINI', 'Яндекс.Станция Мини'),
    35: ('EDUCATION', 'Учебник'),
    36: ('ZEN', 'Дзен'),
    37: ('ELJUR', 'Электронные журналы'),
    38: ('WISP', 'Яндекс.Объявления'),
    39: ('TELEMOST', 'Телемост'),
    40: ('TELEMOST_DESKTOP', 'Телемост, десктопный клиент'),
    41: ('CHEMODAN_ADMIN', 'Админка почты для бизнеса')
};

$Russian_origin = ($origin, $is_team) -> {
    RETURN CASE
        WHEN $origin = 27  -- WEB
            THEN IF ($is_team, 'Web (q.yandex-team.ru)', 'Web (yandex.ru/chat)')
        ELSE $origin_names[$origin].1 ?? ('UNKNOWN ORIGIN:' || CAST($origin AS String))
    END;
};

$namespace_names =  {
    0: ('user group chats', 'Пользовательские групповые чаты'),
    1: ('businesschat/floyd', 'Чаты с бизнесом/флойд'),
    2: ('geochatbot', 'Геочат'),
    3: ('commentator', 'Комментатор'),
    4: ('business chats/floyd', 'Чаты с бизнесом/флойд'),
    5: ('business chats/floyd', 'Чаты с бизнесом/флойд'),
    6: ('local', 'Район'),
    7: ('ether', 'Эфир'),
    8: ('vconf', 'VConf'),
    9: ('browser_api', 'Чаты в браузере'),
    10: ('collections', 'Коллекции'),
    11: ('wizard', 'Организации'),
    12: ('zen', 'Дзен (канальные)'),
    13: ('video', 'Видео'),
    14: ('rtx', 'RTX'),
    15: ('talents', 'Таланты'),
    16: ('sportserp', 'Спортсерп'),
    17: ('education', 'Образование'),
    18: ('wisp', 'Яндекс.Объявления'),
    19: ('el_jour', 'Электронные Журналы'),
    20: ('lyceum', 'Яндекс.Лицей'),
    21: ('btrip', 'Командировки'),
    22: ('telemost', 'Телемост'),
    23: ('b2bgeo', 'B2bGEO'),
    24: ('marketlive', 'Маркет Live'),
    25: ('markethelp', 'Маркет Поддержка Магазинов')
};


$Russian_namespace = ($namespace, $chat_type, $to_robot, $is_robot) -> {
    RETURN CASE
        WHEN $chat_type = 'group_chat'
            THEN $namespace_names[$namespace].1 ?? 'UNDEFINED'
        WHEN $chat_type = '1on1'
            THEN IF ($to_robot OR $is_robot, 'Чаты 1х1 с ботами', 'Чаты 1х1 без ботов')
        WHEN $chat_type = 'channel'
            THEN 'Каналы'
        ELSE 'UNDEFINED'
    END;
};


$light_filter = ($tr) -> (
    $tr.event_subtype = "sending"
    AND $tr.to_count 
    AND NOT $tr.is_robot 
    AND NOT $tr.is_tester
    AND NOT $tr.is_team
);


$default_filter = ($tr) -> (
    $tr.event_subtype = "sending"
    AND $tr.to_count 
    AND NOT $tr.is_robot
    AND NOT $tr.to_robot
    AND NOT $tr.is_tester
    AND NOT $tr.is_team
    AND NOT $tr.is_connect
    AND NOT $tr.is_public_banned
    AND NOT $tr.is_private_banned
);


EXPORT $light_filter, $default_filter, $Russian_namespace, $Russian_origin, $origin_names, $namespace_names;
