PRAGMA yt.PoolTrees = 'physical';
PRAGMA yt.TentativePoolTrees = 'cloud';

USE hahn;

DECLARE $day AS String;
DECLARE $prefix AS String?;

$prefix = $prefix ?? '//home/mssngr';

$start_date = '2019-11-08';
$current_date = $day;
$db = '//home/mssngr/private/current_state/users/' || $current_date;
$sent_messages_all = (SELECT * FROM RANGE('//home/mssngr/squeeze/sent_messages', $start_date));
$output_table = $prefix || '/private/achievement/' || $current_date;

$count_to_level = ($cnt) -> {
    $log = CAST(Math::Floor(Math::Log2(ListMax(AsList($cnt-0.5, 1)))) AS int32);
    RETURN IF($log/2 < 3, 0, IF($log/2 > 7, 5, $log/2-2))
};

INSERT INTO $output_table WITH TRUNCATE
SELECT
    $current_date AS fielddate,
    nickname,
    $count_to_level(message_count) AS level,
    $count_to_level(yesterday_message_count) AS yesterday_level,
    message_count,
    yesterday_message_count,
    $count_to_level(message_count) - $count_to_level(yesterday_message_count) AS level_up,
FROM
(
    SELECT
        COUNT(*) AS message_count,
        COUNT_IF(fielddate<$current_date) AS yesterday_message_count,
        guid,
    FROM $sent_messages_all
    WHERE
        event_subtype = 'sending'
        AND to_count
    ---    AND NOT is_assessor - сейчас этой инфы нет
        AND NOT is_robot
        AND NOT to_robot
        AND is_team
        AND fielddate >= $start_date
        AND chat_id != guid || '_' || guid
    GROUP BY guid
) AS msg_cnt
JOIN (
    SELECT nickname, guid
    FROM $db
    WHERE org_id = 34
) AS db
USING (guid)
ORDER BY fielddate, level_up;
