PRAGMA yt.PoolTrees = 'physical';
PRAGMA yt.TentativePoolTrees = 'cloud';

USE hahn;

DECLARE $day AS String;
DECLARE $prefix AS String;


$week_ago = CAST(CAST($day as Date) - DateTime::IntervalFromDays(7) as STRING);
$chats_table = '//home/mssngr/private/current_state/chats/'||$day;
$chat_members_table = '//home/mssngr/private/current_state/chat_members/'||$day;
$morda_channels = (SELECT chat_id FROM `//home/mssngr/private/morda_channels`);
$testers = (SELECT guid FROM `//home/mssngr/private/current_state/users_testers`);

$channels = (
SELECT chat_id, author, name, invite_hash, (org_id = 34) as is_team, create_timestamp
FROM $chats_table
WHERE chat_id LIKE '1/%'
);

$channel_member = (
SELECT chat_id, SOME(guid) as member, COUNT(*) as member_count
FROM $chat_members_table
WHERE chat_id LIKE '1/%' AND guid NOT IN $testers
GROUP BY chat_id
HAVING COUNT(*) > 1
);

$channels_filtered = (
SELECT l.chat_id as chat_id, name, invite_hash, is_team, create_timestamp, author, member_count, (member_count IS NULL) as is_empty, COALESCE(author IN $testers, false) as is_test_channel, (l.chat_id IN $morda_channels AND l.chat_id != '1/0/d68d12f0-68e2-4c62-9337-4d733f1b10ac') as is_morda
FROM $channels as l
LEFT JOIN $channel_member as r 
USING (chat_id)
);

$active_channels = (
SELECT chat_id, COUNT_IF(fielddate = $day) as post_count, True as is_active
FROM RANGE(`//home/mssngr/squeeze/sent_messages`, $week_ago, $day)
WHERE
    event_subtype = 'sending'
    AND to_count
    AND not is_tester
    AND chat_type = 'channel'
GROUP BY chat_id, is_team
);


$channel_list = '//home/mssngr/tmp/channels/' || $day || '/channel_list';
INSERT INTO $channel_list WITH TRUNCATE
SELECT * FROM (
SELECT 
    l.chat_id as chat_id,
    author,
    post_count,
    member_count,
    AsList(CAST(COALESCE(is_active, FALSE) as STRING), 'all') as is_active,
    AsList(CAST(is_empty as STRING), 'all') as is_empty,
    AsList(CAST(is_morda as STRING), 'all') as is_morda,
    AsList(CAST(is_test_channel as STRING), 'all') as is_test_channel,
    is_team,
    name,
    invite_hash,
    IF(is_team, 'https://q.yandex-team.ru/#/join/', 'https://yandex.ru/chat/#/join/')||invite_hash as invite_link,
    create_timestamp
FROM $channels_filtered as l 
LEFT JOIN $active_channels as r 
USING (chat_id))
FLATTEN LIST BY (is_active, is_empty, is_morda, is_test_channel);

    
    
