PRAGMA yt.PoolTrees = 'physical';
PRAGMA yt.TentativePoolTrees = 'cloud';

USE hahn;

DECLARE $day AS String;
DECLARE $prefix AS String;

$tester_guids = (SELECT guid FROM `//home/mssngr/private/current_state/users_testers`);

$chat_accession_table = '//home/mssngr/private/chat_accession/' || $day;

$chat_events = '//home/mssngr/tmp/channels/' || $day || '/chat_events';
$channel_list = '//home/mssngr/tmp/channels/' || $day || '/channel_list';

INSERT INTO $chat_events WITH TRUNCATE
SELECT
    chat_id,
    event,
    name,
    is_team,
    is_active,
    is_empty,
    is_morda,
    is_test_channel,
    invite_hash,
    invite_link,
    IF(event IN ('leave', 'delete'), guid, NULL) as guid_exit,
    IF(event IN ('add', 'invite'), guid, NULL) as guid_join,
    IF(event = 'leave', guid, NULL) as guid_leave,
    IF(event = 'invite', guid, NULL) as guid_invite,
    IF(event IN ('leave', 'delete'), chat_id, NULL) as chat_exit,
    IF(event IN ('add', 'invite'), chat_id, NULL) as chat_join,
    IF(event = 'leave', chat_id, NULL) as chat_leave,
    IF(event = 'invite', chat_id, NULL) as chat_invite,
    $day as fielddate
FROM 
(
SELECT l.chat_id as chat_id, guid, event, is_team, is_active, is_empty, is_morda, is_test_channel, invite_link, invite_hash, name FROM 
    (SELECT chat_id, guid, event FROM
        $chat_accession_table
    WITH SCHEMA 
        Struct<chat_id:string, guid:string, event:string>
    WHERE 
        chat_id LIKE '1/%' AND guid NOT in $tester_guids) as l
JOIN
    (SELECT * FROM  $channel_list) as r
USING (chat_id)
);
