PRAGMA yt.PoolTrees = 'physical';
PRAGMA yt.TentativePoolTrees = 'cloud';

USE hahn;

DECLARE $day AS String;
DECLARE $prefix AS String;

$output = $prefix || '/general/'||$day;

$input_views = $prefix || '/views/'||$day;
$chat_members = '//home/mssngr/private/current_state/chat_members/'||$day;

$channel_list = '//home/mssngr/tmp/channels/' || $day || '/channel_list';
$chat_events = '//home/mssngr/tmp/channels/' || $day || '/chat_events';

$tester_guids = (SELECT guid FROM `//home/mssngr/private/current_state/users_testers`);
$full_day_ts = CAST(24 AS UINT64)*60*60*1000000;

$views_output = (
SELECT 
    COUNT_IF(guid != '') as messenger_post_views,
    COUNT(DISTINCT chat_id) as channels_viewed,
    COUNT(DISTINCT guid) as guids_viewed,
    COUNT(DISTINCT puid) as puids_viewed,
    COUNT(DISTINCT user_ip) as user_ips_viewed,
    COUNT(*) as post_views,
    fielddate,
    is_team,
    COALESCE(CAST(is_active as STRING), 'all') as is_active,
    is_empty,
    is_test_channel,
    is_morda,
FROM $input_views
GROUP BY fielddate, is_team, is_active, is_empty, is_test_channel, is_morda);

$subscription_output = (
SELECT 
    is_team,
    is_active,
    is_empty,
    is_morda,
    is_test_channel,
    fielddate,
    COUNT_IF(event IN ('leave', 'delete')) as exit_count,
    COUNT_IF(event IN ('add', 'invite')) as join_count,
    COUNT_IF(event = 'leave') as leave_count,
    COUNT_IF(event = 'invite') as invite_count,
    COUNT(DISTINCT guid_exit) as exit_users,
    COUNT(DISTINCT guid_join) as join_users,
    COUNT(DISTINCT guid_leave) as leave_users,
    COUNT(DISTINCT guid_invite) as invite_users,
    COUNT(DISTINCT chat_exit) as exit_chats,
    COUNT(DISTINCT chat_join) as join_chats,
    COUNT(DISTINCT chat_leave) as leave_chats,
    COUNT(DISTINCT chat_invite) as invite_chats
FROM $chat_events
GROUP BY is_team, fielddate, is_active, is_empty, is_morda, is_test_channel);


$totals_output = (

SELECT
    COUNT(*) as total_channels,
    SUM(post_count) as post_count,
    COUNT_IF(CAST(create_timestamp as Timestamp) >= CAST($day as Date) AND CAST(create_timestamp-$full_day_ts as Timestamp) < CAST($day as Date)) as channels_created,
    $day as fielddate,
    is_team,
    is_active,
    is_empty,
    is_morda,
    is_test_channel

FROM $channel_list

GROUP BY is_team, is_active, is_empty, is_morda, is_test_channel);

$total_subscribers = (

SELECT COUNT(DISTINCT guid) as total_subscribers, $day as fielddate, is_team, is_active, is_empty, is_morda, is_test_channel FROM
(SELECT guid, author,
is_team, is_active, is_empty, is_morda, is_test_channel FROM 
$channel_list as l 
JOIN $chat_members  as r
USING (chat_id)
WHERE (author IS NULL or guid != author) AND guid NOT IN $tester_guids)
GROUP BY is_team, is_active, is_empty, is_morda, is_test_channel
);







INSERT INTO $output WITH TRUNCATE
SELECT
    COALESCE(`messenger_post_views`, 0) as `messenger_post_views`,
    COALESCE(`leave_count`, 0) as `leave_count`,
    COALESCE(`total_channels`, 0) as `total_channels`,
    COALESCE(`total_subscribers`, 0) as `total_subscribers`,
    COALESCE(`channels_created`, 0) as `channels_created`,
    COALESCE(`invite_users`, 0) as `invite_users`,
    COALESCE(`invite_count`, 0) as `invite_count`,
    COALESCE(`join_count`, 0) as `join_count`,
    COALESCE(l.fielddate, '0000-00-00') as fielddate, 
    COALESCE(l.is_team, true) as is_team,
    COALESCE(l.is_active, 'all') as is_active,
    COALESCE(l.is_empty, 'all') as is_empty,
    COALESCE(l.is_morda, 'all') as is_morda,
    COALESCE(l.is_test_channel, 'all') as is_test_channel,
    COALESCE(`exit_count`, 0) as `exit_count`,
    COALESCE(`exit_users`, 0) as `exit_users`,
    COALESCE(`join_chats`, 0) as `join_chats`,
    COALESCE(`leave_users`, 0) as `leave_users`,
    COALESCE(`join_users`, 0) as `join_users`,
    COALESCE(`invite_chats`, 0) as `invite_chats`,
    COALESCE(`exit_chats`, 0) as `exit_chats`,
    COALESCE(`post_count`, 0) as `post_count`,
    COALESCE(`leave_chats`, 0) as `leave_chats`,
    COALESCE(`post_views`, 0) as `post_views`,
    COALESCE(`guids_viewed`, 0) as `guids_viewed`,
    COALESCE(`puids_viewed`, 0) as `puids_viewed`,
    COALESCE(`user_ips_viewed`, 0) as `user_ips_viewed`,
    COALESCE(`channels_viewed`, 0) as `channels_viewed`
FROM (SELECT * FROM $views_output as l JOIN $totals_output as r USING (fielddate, is_team, is_active, is_empty, is_morda, is_test_channel)) as l
FULL JOIN
(SELECT * FROM $subscription_output as l JOIN $total_subscribers as r USING (fielddate, is_team, is_active, is_empty, is_morda, is_test_channel)) as r
USING (fielddate, is_team, is_active, is_empty, is_morda, is_test_channel)
ORDER BY fielddate, is_team, is_active, is_empty, is_test_channel, is_morda;

