PRAGMA yt.PoolTrees = 'physical';
PRAGMA yt.TentativePoolTrees = 'cloud';

USE hahn;

DECLARE $day AS String;
DECLARE $prefix AS String;

$tester_guids = (SELECT guid FROM `//home/mssngr/private/current_state/users_testers`);

$db_chats = '//home/mssngr/private/current_state/chats/' || $day;
$db_chat_members = '//home/mssngr/private/current_state/chat_members/' || $day;
$sent_messages = '//home/mssngr/squeeze/sent_messages/' || $day;

$channel_list = '//home/mssngr/tmp/channels/' || $day || '/channel_list';

$output = $prefix||'/histograms/'||$day;

$chat_members = (
SELECT l.chat_id as chat_id, guid, is_team, is_active, is_empty, is_test_channel, is_morda, COALESCE((author = guid), FALSE) as is_author
FROM $db_chat_members as l 
JOIN
$channel_list as r
USING (chat_id)
WHERE guid NOT IN $tester_guids
);




$users_by_chats = (
SELECT CAST(COUNT(guid) as int32)-1 as user_count, chat_id, is_team, is_active, is_empty, is_test_channel, is_morda, $day as fielddate
FROM $chat_members
GROUP BY chat_id, is_team, is_active, is_empty, is_test_channel, is_morda);

$chats_by_users = (
SELECT CAST(COUNT(chat_id) as int32) as chat_count, guid, is_team, is_active, is_empty, is_test_channel, is_morda, $day as fielddate
FROM $chat_members
WHERE NOT is_author
GROUP BY guid, is_team, is_active, is_empty, is_test_channel, is_morda);

$out_1 = (
SELECT count(*) as `count`, value, 'users_by_chat' as `type`, fielddate, is_team, is_active, is_empty, is_test_channel, is_morda FROM $users_by_chats GROUP BY user_count as value, fielddate, is_team, is_active, is_empty, is_test_channel, is_morda
UNION ALL
SELECT count(*) as `count`, value, 'chats_by_user' as `type`, fielddate, is_team, is_active, is_empty, is_test_channel, is_morda FROM $chats_by_users GROUP BY chat_count as value, fielddate, is_team, is_active, is_empty, is_test_channel, is_morda);


$channel_posts = 
(
SELECT 
    chat_id,
    is_team,
    is_active,
    is_empty,
    is_morda,
    is_test_channel,
    $day as fielddate,
    post_count
FROM
    $channel_list
);

$out_2 = (
SELECT COUNT(*) as `count`, value, 'posts_by_chat' as `type`, fielddate, is_team, is_active, is_empty, is_morda, is_test_channel
FROM
$channel_posts
GROUP BY post_count as value, fielddate, is_team, is_active, is_empty, is_test_channel, is_morda);

INSERT INTO $output WITH TRUNCATE
SELECT * FROM $out_1
UNION ALL
SELECT * FROM $out_2;
