PRAGMA yt.PoolTrees = 'physical';
PRAGMA yt.TentativePoolTrees = 'cloud';

USE hahn;

DECLARE $day AS String;
DECLARE $prefix AS String;


$raw_views = '//home/mssngr/tmp/channels/' || $day || '/raw_views';
$router_event_log = '//home/logfeller/logs/mssngr-router-event-log/1d/' || $day;

INSERT INTO $raw_views WITH TRUNCATE
SELECT $day as `fielddate`,`Timestamp` as `msg_timestamp`, `Guid` as `guid`, `Uid` as `puid`, `UserIp` as `user_ip`, `ChatId` as `chat_id`, `Origin` as `origin` FROM
(
    SELECT 
        `Timestamp`, frame_id, source_uri
    FROM $router_event_log
    WHERE Success AND event_name = 'TMessageViewProcessed'
) as a
JOIN
(
    SELECT
        Guid, UserIp, Uid, ChatId, Origin, frame_id, source_uri
    FROM $router_event_log
    WHERE `Type`=16 AND event_name = 'TInMessageInfo' AND ChatId LIKE '1/%' ---some autotests have double guid as chatid
) as b 
USING (frame_id, source_uri)
ORDER BY `fielddate`
