PRAGMA yt.PoolTrees = 'physical';
PRAGMA yt.TentativePoolTrees = 'cloud';

USE hahn;

DECLARE $day AS String;
DECLARE $prefix AS String;

$tester_guids = (SELECT guid FROM `//home/mssngr/private/current_state/users_testers`);


$subtract_days = ($i) -> {RETURN CAST(CAST($day as Date) - $i*DateTime::IntervalFromDays(1) as STRING)};
$one_day_ago = CAST(CAST($day as Date) - DateTime::IntervalFromDays(1) as STRING);
$three_days_ago = CAST(CAST($day as Date) - DateTime::IntervalFromDays(3) as STRING);
$week_ago = CAST(CAST($day as Date) - DateTime::IntervalFromDays(7) as STRING);


$chat_events = '//home/mssngr/tmp/channels/' || $day || '/chat_events';
$channel_list = '//home/mssngr/tmp/channels/' || $day || '/channel_list';

$output = $prefix||'/daily_top/'||$day;

$input_views_table = $prefix||'/views';
$input_views = $input_views_table||$day;
$chat_members = '//home/mssngr/private/current_state/chat_members/'||$day;



$group_by_chat = (SELECT 
    is_team,
    is_active,
    is_empty,
    is_morda,
    is_test_channel,
    fielddate,
    chat_id,
    SOME(invite_link) as invite_link,
    SOME(name) as name,
    COALESCE(CAST(COUNT(DISTINCT guid_leave) as int32), 0) as exit_users,
    COALESCE(CAST(COUNT(DISTINCT guid_invite) as int32), 0) as join_users,
    COALESCE(CAST(COUNT_IF(event IN ('invite')) as int32) - CAST(COUNT_IF(event IN ('leave')) as int32), 0) as member_diff
FROM $chat_events
GROUP BY is_team, is_active, is_empty, is_test_channel, is_morda, fielddate, chat_id);

$you_are_prepared = 
(SELECT
    is_team,
    is_active,
    is_empty,
    is_morda,
    is_test_channel,
    fielddate,
    chat_id,
    invite_link,
    name,
    'users_unsubscribed' as `type`,
    exit_users as `count`
FROM
    $group_by_chat
UNION ALL
SELECT
    is_team,
    is_active,
    is_empty,
    is_morda,
    is_test_channel,
    fielddate,
    chat_id,
    invite_link,
    name,
    'users_subscribed' as `type`,
    join_users as `count`
FROM
    $group_by_chat
UNION ALL
SELECT
    is_team,
    is_active,
    is_empty,
    is_morda,
    is_test_channel,
    fielddate,
    chat_id,
    invite_link,
    name,
    'users_top_diff' as `type`,
    member_diff as `count`
FROM
    $group_by_chat
UNION ALL
SELECT
    is_team,
    is_active,
    is_empty,
    is_morda,
    is_test_channel,
    fielddate,
    chat_id,
    invite_link,
    name,
    'users_bot_diff' as `type`,
    -member_diff as `count`
FROM
    $group_by_chat
UNION ALL
SELECT 
    is_team,
    is_active,
    is_empty,
    is_morda,
    is_test_channel,
    $day as fielddate,
    'members' as `type`,
    chat_id,
    CAST(member_count as int32) as `count`,
    name,
    invite_link
FROM $channel_list
);

$subscribers_info = (
SELECT 
    is_team,
    is_active,
    is_empty,
    is_morda,
    is_test_channel,
    $day as fielddate,
    `type`,
    ROW_NUMBER() OVER w as position,
    chat_id,
    `count`,
    name,
    invite_link
FROM $you_are_prepared
WINDOW w AS (PARTITION BY is_team, is_active, is_empty, is_test_channel, is_morda, `type` ORDER BY `count` DESC)
-- ORDER BY fielddate, is_team, is_active, is_empty, is_test_channel, is_morda, `type`, position
);




$channel_views = (
SELECT 
    v.chat_id as chat_id, name, invite_link,
    v.is_team as is_team, v.is_active as is_active, v.is_empty as is_empty, v.is_test_channel as is_test_channel, v.is_morda as is_morda,
    one_day_views, three_day_views, one_week_views
    
FROM 
    (SELECT 
        chat_id, is_team, is_active, is_empty, is_test_channel, is_morda,
        COUNT_IF(fielddate > $subtract_days(1)) as one_day_views, 
        COUNT_IF(fielddate > $subtract_days(3)) as three_day_views, 
        COUNT_IF(fielddate > $subtract_days(7)) as one_week_views
    FROM RANGE($input_views_table, $week_ago, $day)
    GROUP BY chat_id, is_team, is_active, is_empty, is_test_channel, is_morda) as v
JOIN $channel_list as r
USING (chat_id, is_team, is_active, is_empty, is_test_channel, is_morda)
);


$post_views = (
SELECT 
    v.chat_id as chat_id, name, invite_link||'/'||CAST(msg_timestamp as STRING) as invite_link,
    v.is_team as is_team, v.is_active as is_active, v.is_empty as is_empty, v.is_test_channel as is_test_channel, v.is_morda as is_morda,
    one_day_views, three_day_views, one_week_views
FROM
    (SELECT
        chat_id, `msg_timestamp`, is_team, is_active, is_empty, is_test_channel, is_morda,
        COUNT_IF(fielddate > $subtract_days(1)) as one_day_views, 
        COUNT_IF(fielddate > $subtract_days(3)) as three_day_views, 
        COUNT_IF(fielddate > $subtract_days(7)) as one_week_views
    FROM RANGE($input_views_table, $week_ago, $day)
    GROUP BY chat_id, msg_timestamp, is_team, is_active, is_empty, is_test_channel, is_morda) as v
JOIN $channel_list as r
USING (chat_id, is_team, is_active, is_empty, is_test_channel, is_morda)
);

$result_1 = (
SELECT 
    is_team,
    is_active,
    is_empty,
    is_morda,
    is_test_channel,
    $day as fielddate,
    ROW_NUMBER() OVER w as position,
    'post_one_day_views' as `type`,
    chat_id,
    CAST(one_day_views as int32) as `count`,
    name,
    invite_link
FROM $post_views
WHERE one_day_views != 0
WINDOW w AS (PARTITION BY is_team, is_active, is_empty, is_test_channel, is_morda ORDER BY one_day_views DESC)
UNION ALL
SELECT 
    is_team,
    is_active,
    is_empty,
    is_morda,
    is_test_channel,
    $day as fielddate,
    ROW_NUMBER() OVER w as position,
    'post_three_day_views' as `type`,
    chat_id,
    CAST(three_day_views as int32) as `count`,
    name,
    invite_link
FROM $post_views
WHERE three_day_views != 0
WINDOW w AS (PARTITION BY is_team, is_active, is_empty, is_test_channel, is_morda ORDER BY three_day_views DESC)
UNION ALL
SELECT 
    is_team,
    is_active,
    is_empty,
    is_morda,
    is_test_channel,
    $day as fielddate,
    ROW_NUMBER() OVER w as position,
    'post_one_week_views' as `type`,
    chat_id,
    CAST(one_week_views as int32) as `count`,
    name,
    invite_link
FROM $post_views
WHERE one_week_views != 0
WINDOW w AS (PARTITION BY is_team, is_active, is_empty, is_test_channel, is_morda ORDER BY one_week_views DESC)
);

$result_2 = (
SELECT 
    is_team,
    is_active,
    is_empty,
    is_morda,
    is_test_channel,
    $day as fielddate,
    ROW_NUMBER() OVER w as position,
    'channel_one_day_views' as `type`,
    chat_id,
    CAST(one_day_views as int32) as `count`,
    name,
    invite_link
FROM $channel_views
WHERE one_day_views != 0
WINDOW w AS (PARTITION BY is_team, is_active, is_empty, is_test_channel, is_morda ORDER BY one_day_views DESC)
UNION ALL
SELECT 
    is_team,
    is_active,
    is_empty,
    is_morda,
    is_test_channel,
    $day as fielddate,
    ROW_NUMBER() OVER w as position,
    'channel_three_day_views' as `type`,
    chat_id,
    CAST(three_day_views as int32) as `count`,
    name,
    invite_link
FROM $channel_views
WHERE three_day_views != 0
WINDOW w AS (PARTITION BY is_team, is_active, is_empty, is_test_channel, is_morda ORDER BY three_day_views DESC)
UNION ALL
SELECT 
    is_team,
    is_active,
    is_empty,
    is_morda,
    is_test_channel,
    $day as fielddate,
    ROW_NUMBER() OVER w as position,
    'channel_one_week_views' as `type`,
    chat_id,
    CAST(one_week_views as int32) as `count`,
    name,
    invite_link
FROM $channel_views
WHERE one_week_views != 0
WINDOW w AS (PARTITION BY is_team, is_active, is_empty, is_test_channel, is_morda ORDER BY one_week_views DESC)
);

INSERT INTO $output WITH TRUNCATE 
SELECT * FROM (
SELECT * FROM $result_1
UNION ALL
SELECT * FROM $result_2
UNION ALL
SELECT * FROM $subscribers_info
)
ORDER BY is_team, is_active, is_empty, is_morda, is_test_channel;



