PRAGMA yt.PoolTrees = 'physical';
PRAGMA yt.TentativePoolTrees = 'cloud';

USE hahn;

DECLARE $day AS String;
DECLARE $prefix AS String;


$users = '//home/mssngr/private/current_state/users/' || $day;
$tester_guids = (SELECT guid FROM `//home/mssngr/private/current_state/users_testers`);
$tester_puids = (SELECT puid FROM $users WHERE is_tester);

$output = $prefix || '/views/' || $day;
$raw_views = '//home/mssngr/tmp/channels/' || $day || '/raw_views';
$channel_list = '//home/mssngr/tmp/channels/' || $day || '/channel_list';

INSERT INTO $output WITH TRUNCATE
SELECT 
`fielddate`,
`msg_timestamp`, 
`guid` as `guid`, 
`puid` as `puid`, 
`user_ip` as `user_ip`,
l.`chat_id` as `chat_id`,
`origin`,
`is_team`,
is_active,
is_empty,
is_test_channel,
is_morda
FROM $raw_views as l
JOIN $channel_list  as r
USING (chat_id)
WHERE guid NOT IN $tester_guids AND puid NOT IN $tester_puids;
