PRAGMA yt.PoolTrees = 'physical';
PRAGMA yt.TentativePoolTrees = 'cloud';

USE hahn;

DECLARE $day AS String;
DECLARE $prefix AS String?;
DECLARE $id AS String;
DECLARE $timestamp AS Int64;

$prefix = $prefix ?? '//home/mssngr';
$revision = CAST($timestamp AS String) || '_' || $id;

$users = '//home/mssngr/private/current_state/users/' || $day;
$tmp_reactions = '//home/mssngr/tmp/squeeze_' || $day || '/reactions';

$to_whom = ($chat_id, $guid) -> {
    $i = FIND($chat_id, '_');
    $a = SUBSTRING($chat_id, NULL, $i);
    $b = SUBSTRING($chat_id, $i+1u);
    RETURN IF($a == $guid, $b, $a);
};

$is_connect = ($organizations_1, $organizations_2) -> (
    NOT SetIsDisjoint(
        ToSet(Yson::ConvertToInt64List(CAST($organizations_1 AS Json))),
        ToSet(Yson::ConvertToInt64List(CAST($organizations_2 AS Json))),
    )
);

-- prepare data
$tmp_data = (
    SELECT
        event_subtype,
        iso_eventtime,
        subservice,
        frame_id,
        is_valid,
        yandexuid,
        msg_timestamp,
        chat_type,
        user_agent,
        tvm_service_id,
        source_uri,
        event_timestamp,
        origin,
        reaction_type,
        namespace,
        event,
        chat_id,
        status_code,

        to_guid,

        data.guid AS guid,
        users.puid??0 AS puid,

        $day AS fielddate,
        false AS is_assessor,

        users.is_robot??false AS is_robot,
        IF(users.is_limit IS NULL, 'l', IF(users.is_limit, 'lu', 'u')) AS user_type,
        (users.org_id == 34)??false AS is_team,
        users.is_tester??false AS is_tester,
        users.is_public_banned AS is_public_banned,
        users.is_private_banned AS is_private_banned,

        $is_connect(users.organizations, users_2.organizations) AS is_connect,
    FROM (
        SELECT
            event_subtype,
            iso_eventtime,
            subservice,
            frame_id,
            is_valid,
            yandexuid,
            msg_timestamp,
            chat_type,
            user_agent,
            tvm_service_id,
            source_uri,
            event_timestamp,
            origin,
            reaction_type,
            namespace,
            event,
            chat_id,
            status_code,

            data.puid AS puid,
            users.guid??data.guid AS guid,
            IF(chat_id LIKE '%/%', NULL, $to_whom(chat_id, data.guid)) AS to_guid,
        FROM $tmp_reactions AS data
        LEFT JOIN $users AS users
        USING (puid)
    ) AS data
    LEFT JOIN $users AS users ON users.guid = data.guid
    LEFT JOIN $users AS users_2 ON users_2.guid = data.to_guid
);

-- squeeze seen markers
$reactions = $prefix || '/squeeze_data/reactions/' || $day || '/' || $revision;

INSERT INTO $reactions WITH TRUNCATE
SELECT
    event_subtype,
    iso_eventtime,
    subservice,
    frame_id,
    is_valid,
    yandexuid,
    msg_timestamp,
    chat_type,
    user_agent,
    tvm_service_id,
    source_uri,
    event_timestamp,
    origin,
    reaction_type,
    namespace,
    event,
    chat_id,
    status_code,
    to_guid,
    guid,
    puid,
    fielddate,
    is_assessor,
    is_robot,
    user_type,
    is_team,
    is_tester,
    to_puid??0 AS to_puid,
    to_robot??false AS to_robot,
    (
        chat_id NOT LIKE '%bbfb7e89-a736-4144-8f41-0525ff3a136d%'
        AND chat_id NOT LIKE '%f93750b5-2cdd-4258-96aa-cbe2acd51607%'
        AND tvm_service_id != 2002328
    ) AS to_count, --- autotest and echotest bots, debug
    is_connect,
    is_public_banned,
    is_private_banned,
FROM (
    SELECT *
    FROM $tmp_data AS tmp_data
    LEFT JOIN (
        SELECT guid AS to_guid, is_robot AS to_robot, puid AS to_puid FROM $users
    ) AS users
    USING (to_guid)
)
ORDER BY fielddate, iso_eventtime;
