PRAGMA yt.PoolTrees = "physical";
PRAGMA yt.TentativePoolTrees = "cloud";

USE hahn;

$day_from = '2020-04-01';
$day_to = '2020-06-16';
$prefix = '//home/mssngr';
$revision = '1593082532_update_fraud_and_connect_v1';
$seen_markers = '//home/mssngr/squeeze/seen_markers';

$get_table_name = ($path) -> (
    ListLast(String::SplitToList($path, '/'))
);

$days = (
    SELECT AGGREGATE_LIST($get_table_name(Path))
    FROM FOLDER($seen_markers)
    WHERE
        Type = 'table'
        AND $get_table_name(Path) BETWEEN $day_from AND $day_to
);

$is_connect = ($organizations_1, $organizations_2) -> (
    NOT SetIsDisjoint(
        ToSet(Yson::ConvertToInt64List(CAST($organizations_1 AS Json))),
        ToSet(Yson::ConvertToInt64List(CAST($organizations_2 AS Json))),
    )
);

EVALUATE FOR $day IN $days DO BEGIN
    $users = '//home/mssngr/private/current_state/users/' || $day;

    $seen_markers_old = $seen_markers  || '/' || $day;
    $seen_markers_new = $prefix || '/squeeze_data/seen_markers/' || $day || '/' || $revision;

    INSERT INTO $seen_markers_new WITH TRUNCATE
    SELECT
        chat_id,
        chat_type,
        event_timestamp,
        event,
        fielddate,
        frame_id,
        from_guid,
        from_puid,
        from_robot,
        is_assessor,
        is_team,
        is_valid,
        iso_eventtime,
        msg_timestamp,
        namespace,
        origin,
        source_uri,
        status_code,
        subservice,
        to_count,
        tvm_service_id,
        user_agent,
        user_type,
        yandexuid,

        messages.guid AS guid,
        messages.is_robot AS is_robot,
        messages.is_tester AS is_tester,
        messages.puid AS puid,

        -- new columns
        $is_connect(users.organizations, users_from.organizations) AS is_connect,
        users.is_public_banned AS is_public_banned,
        users.is_private_banned AS is_private_banned,
    FROM $seen_markers_old AS messages
    LEFT JOIN $users AS users ON users.guid = messages.guid
    LEFT JOIN $users AS users_from ON users_from.guid = messages.from_guid
    ORDER BY fielddate, iso_eventtime;
END DO;
