PRAGMA yt.PoolTrees = "physical";
PRAGMA yt.TentativePoolTrees = "cloud";

USE hahn;

$day_from = '2020-04-01';
$day_to = '2020-06-16';
$prefix = '//home/mssngr';
$revision = '1593082532_update_fraud_and_connect_v1';
$sent_messages = '//home/mssngr/squeeze/sent_messages';

$get_table_name = ($path) -> (
    ListLast(String::SplitToList($path, '/'))
);

$days = (
    SELECT AGGREGATE_LIST($get_table_name(Path))
    FROM FOLDER($sent_messages)
    WHERE
        Type = 'table'
        AND $get_table_name(Path) BETWEEN $day_from AND $day_to
);

$is_connect = ($organizations_1, $organizations_2) -> (
    NOT SetIsDisjoint(
        ToSet(Yson::ConvertToInt64List(CAST($organizations_1 AS Json))),
        ToSet(Yson::ConvertToInt64List(CAST($organizations_2 AS Json))),
    )
);

EVALUATE FOR $day IN $days DO BEGIN
    $users = '//home/mssngr/private/current_state/users/' || $day;

    $sent_messages_old = $sent_messages || '/' || $day;
    $sent_messages_new = $prefix || '/squeeze_data/sent_messages/' || $day || '/' || $revision;

    INSERT INTO $sent_messages_new WITH TRUNCATE
    SELECT
        chat_id,
        chat_type,
        event_subtype,
        event_timestamp,
        event,
        fielddate,
        frame_id,
        hash,
        is_assessor,
        is_reply,
        is_team,
        is_valid,
        iso_eventtime,
        msg_timestamp,
        namespace,
        origin,
        parent_timestamp,
        payload_id,
        payload_type,
        source_uri,
        status_code,
        subservice,
        to_count,
        to_guid,
        to_puid,
        to_robot,
        tvm_service_id,
        user_agent,
        user_type,
        yandexuid,

        messages.guid AS guid,
        messages.is_robot AS is_robot,
        messages.is_tester AS is_tester,
        messages.puid AS puid,

        -- new columns
        $is_connect(users.organizations, users_to.organizations) AS is_connect,
        users.is_public_banned AS is_public_banned,
        users.is_private_banned AS is_private_banned,
    FROM $sent_messages_old AS messages
    LEFT JOIN $users AS users ON users.guid = messages.guid
    LEFT JOIN $users AS users_to ON users_to.guid = messages.to_guid
    ORDER BY fielddate, iso_eventtime;
END DO;
