PRAGMA yson.DisableStrict;
PRAGMA yt.InferSchema = '1';
PRAGMA yt.PoolTrees = "physical";
PRAGMA yt.TentativePoolTrees = "cloud";

USE hahn;

DECLARE $day AS String;
DECLARE $numdays AS Integer;

$dates = ListReverse(ListMap(ListFromRange(0, $numdays), ($d) -> {
    RETURN DateTime::Format('%Y-%m-%d')(DateTime::MakeDate(DateTime::Parse('%Y-%m-%d')($day)) - $d * Interval('P1D'));
}));

EVALUATE FOR $dt IN $dates DO BEGIN
    $push_token = 'home/mssngr/private/push_tokens/' || $dt;
    $mssngr_user = 'home/mssngr/private/current_state/users/' || $dt;

    $squeeze_folder = 'home/mssngr/squeeze/push_tokens/';
    $yesterday = DateTime::Format('%Y-%m-%d')(DateTime::MakeDate(DateTime::Parse('%Y-%m-%d')($dt)) - Interval('P1D'));
    $yesterday_squeeze = $squeeze_folder || $yesterday;
    $destination = $squeeze_folder || $dt;

    $push_token_schema = Struct<guid:String, app_uuid:String, package_name:String, token_type:String, yandexuid:Yson?>;

    $squeeze = (
        SELECT
            DateTime::MakeDate(DateTime::Parse('%Y-%m-%d')($dt)) AS day,
            mu.puid AS puid,
            pt.guid AS guid,
            pt.app_uuid AS app_uuid,
            pt.package_name AS package_name,
            pt.token_type AS token_type,
            CAST(Yson::ConvertToUint64(pt.yandexuid) AS String) AS yandexuid,
        FROM $push_token WITH SCHEMA $push_token_schema AS pt
        LEFT JOIN $mssngr_user AS mu ON mu.guid = pt.guid

        -- Comment these two rows if you need to squeeze days before 2020-04-13 inclusive
        UNION ALL
        SELECT
            DateTime::MakeDate(DateTime::Parse('%Y-%m-%d')($dt)) AS day,
            puid, guid, app_uuid, package_name, token_type, yandexuid,
        FROM $yesterday_squeeze
    );

    INSERT INTO $destination WITH TRUNCATE
    SELECT * FROM $squeeze
    ORDER BY day, puid;

    COMMIT;
END DO;
