PRAGMA yt.PoolTrees = 'physical';
PRAGMA yt.TentativePoolTrees = 'cloud';
PRAGMA yson.DisableStrict;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

USE hahn;

DECLARE $day AS String;
DECLARE $prefix AS String?;

$prefix = $prefix ?? '//home/mssngr';

$to_whom = ($chat_id, $guid) -> {
    $i = FIND($chat_id, '_');
    $a = SUBSTRING($chat_id, NULL, $i);
    $b = SUBSTRING($chat_id, $i+1u);
    RETURN IF($a == $guid, $b, $a);
};

$mssngr_tags = ($chat_id, $origin_service) -> {
    $result = AsList('mssngr');

    -- namespace source: https://bitbucket.browser.yandex-team.ru/projects/MSSNGR/repos/messenger-backend-history/browse/src/yamb/utils/default.py#573
    $namespace = CASE
        WHEN $chat_id LIKE '0/6/%' THEN AsList('district')
        WHEN $chat_id LIKE '0/7/%' THEN AsList('ether')
        WHEN $chat_id LIKE '0/9/%' THEN AsList('website_chats')
        WHEN $chat_id LIKE '0/10/%' THEN AsList('collections')
        WHEN $chat_id LIKE '0/13/%' THEN AsList('video')
        ELSE ListCreate(String)
    END;

    -- origin source: https://a.yandex-team.ru/arc/trunk/arcadia/mssngr/router/lib/protos/message.proto?rev=6203993#L86
    $origin_tag = CASE $origin_service
        WHEN 2 THEN AsList('serp')
        WHEN 3 THEN AsList('district')
        WHEN 4 THEN AsList('ether')
        WHEN 10 THEN AsList('morda')
        WHEN 16 THEN AsList('geo')
        WHEN 18 THEN AsList('collections')
        WHEN 32 THEN AsList('video')
        ELSE ListCreate(String)
    END;
    $host = CASE $origin_service
                WHEN 5 THEN AsList('mssngr_ios_searchapp')
                WHEN 6 THEN AsList('mssngr_ios_browser')
                WHEN 7 THEN AsList('mssngr_ios_standalone')
                WHEN 24 THEN AsList('mssngr_android_searchapp')
                WHEN 25 THEN AsList('mssngr_android_browser')
                WHEN 26 THEN AsList('mssngr_android_standalone')
                ELSE ListCreate(String)
            END;
    $platform = AsList(IF (($origin_service ?? 0) IN (5,6,7), 'mssngr_ios',
    IF(($origin_service ?? 0) IN (17,24,25,26), 'mssngr_android',
    'mssngr_web')));
    RETURN ListExtend($result, $namespace, $origin_tag, $host, $platform)
};

$users_table = '//home/mssngr/private/current_state/users/' || $day;

$outputtable = $prefix || '/squeeze/social_v2/appmetrica/' || $day;
$inputtable_appmetrika = '//statbox/metrika-mobile-log/' || $day;

INSERT INTO $outputtable WITH TRUNCATE 
SELECT
    CAST(puid AS STRING) AS puid,
    CAST(SendTimestamp AS INT32) AS ts,
    'blue' AS color, EventName AS action_type,
    'chat_id:' || chat_id AS action_target,
    'touch' AS useragent,
    chat_id,
    origin,
    $mssngr_tags(chat_id, origin) AS tags,
    AppID,
    APIKey,
FROM (
    SELECT
        (Yson::LookupString(Yson::ParseJson(EventValue), 'chat')??Yson::LookupString(Yson::ParseJson(EventValue), 'chat_id'))as chat_id,
        -- Yson::LookupString(Yson::ParseJson(EventValue), 'msg_timestamp') AS `type`,
        Yson::LookupString(
            Yson::ParseJson(`ReportEnvironment_Values`),
            COALESCE(
                CAST(
                    Listindexof(
                        Yson::ConvertToStringList(Yson::ParseJson(`ReportEnvironment_Keys`)),
                        'guid'
                    ) AS STRING
                ),
                ''
            )
        ) AS guid,
        EventName,
        SendTimestamp,
        AppID,
        APIKey,

        CASE
            WHEN APIKey = '1630031' AND AppID LIKE 'ru.yandex.searchplugin%' THEN 24
            WHEN APIKey = '1630031' AND AppID LIKE 'com.yandex.browser%' THEN 25
            WHEN APIKey = '1630031' AND AppID LIKE 'com.yandex.yamb%' THEN 26
            WHEN APIKey = '2126725' AND AppID = 'ru.yandex.mobile' THEN 5
            WHEN APIKey = '2126725' AND AppID LIKE 'ru.yandex.mobile.search%' THEN 6
            WHEN APIKey = '2126725' AND AppID LIKE 'ru.yandex.mobile.yamb%' OR AppID LIKE 'ru.yandex.messenger%' THEN 7
            ELSE 0
        END AS origin
FROM $inputtable_appmetrika
WHERE
    APIKey IN ('1630031', '2126725')
    AND EventName IN ('message shown', 'chat opened')
) AS  l
JOIN (
    SELECT puid, guid FROM $users_table WHERE NOT is_robot
) AS r
USING (guid)
WHERE
    chat_id NOT LIKE '1/%'
    AND (
        chat_id LIKE '0/%'
        OR $to_whom(chat_id, l.guid) NOT IN (SELECT guid from $users_table WHERE is_robot)
    )
    AND chat_id != l.guid || '_' || l.guid;
