# -*- coding: UTF-8 -*-

# 0) т.к. это эксперимент, цикл по датам прописан руками
# 1) идем по user_sessions, собираем запросы к поиску пользователей из выборок
# 2) идем по redir_log, собираем редиректы с path={yes,no,error,control-yes,control-no,control-error}
# 3) для таблиц, построенных по user_sessions и по redir_log получаем число пользователей
# 4) джойним таблицы из user_sessions и redir_log, чтобы посмотреть, сколько запросов к поиску было у пользователей, у которых были редиректы
# 5) вычисляем количество уидов в поджойненных таблицах

from mapreducelib import MapReduce, Record
from collections import defaultdict
import sys
from datetime import datetime
import libra
import urllib, cgi
import random

path_to_blockstat_dict = '/home/ensuetina/data/blockstat.dict' # получить bsd: curl https://stat.yandex-team.ru/export_something_to_search.cgi?type=blockstat_dict > blockstat.dict
cluster_path_prefix = 'ensuetina/RESEARCH_1403'

# скачать свежую либру: rsync veles02::Berkanavt/logs/bin/libra.so ./

tags = ['16233','16234']
e = ['yes','no','error']
c = ['control-yes','control-no','control-error']

def GetSerpReqs(key, recs): # выбираем из user_sessions все запросы к серпу у пользователей из выборок
    uid = key
    if uid[0] != 'y':
        return

    try:
        s = libra.ParseSession(recs, './blockstat.dict')
    except RuntimeError as e:
        if 'fat user' in str(e):
            return
        if 'ParseSession can' in str(e):
            return
        else:
            raise e

    for r in s:
        if not r.IsA("TYandexWebRequest"):
            continue

        if r.ServiceDomRegion != 'ru':
            continue

        if r.HasTestID(tags[0]):
            slot = 'control ' + tags[0]
            TI = 0
        elif r.HasTestID(tags[1]):
            slot = 'exp ' + tags[1]
            TI = 1
        else:
            continue

        ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]
        req = urllib.unquote(str(r.FullRequest))

        yield Record(uid, slot, ts + '\t' + req, tableIndex = TI) # тут все запросы пользователей

# выбираем из redir_log запросы с редиректами
def GrepRedir(rec):
    line = rec.value
    if '@@pid=40@@' in line and '@@cid=72863@@' in line:
        ctype = 'img'
    elif '@@pid=197@@' in line and '@@cid=72894@@' in line:
        ctype = 'vid'
    else:
        return

    data = dict([d.split('=', 1) for d in line.split('@@') if '=' in d])

    l = line.split('@@')
    ts = l[len(l)-3]

    try:
        day = str(datetime.fromtimestamp(float(ts)).isoformat()).split('T')[0]
    except:
        day = '-'

    if 'yuid' in data:
        uid = 'y' + data['yuid']
    else:
        uid = '-'

    if 'reqid' in data:
        reqid = data['reqid']
    else:
        reqid = '-'

    if 'path' in data:
        path = data['path']
    else:
        path = '-'

    if path in c:
        yield Record(uid, path, day + '\t' + ctype + '\t' + reqid, tableIndex = 0) # control yes, no, error
    elif path in e:
        yield Record(uid, path, day + '\t' + ctype + '\t' + reqid, tableIndex = 1) # exp yes, no, error

#    yield Record(uid, path, day + '\t' + ctype + '\t' + reqid + '\t' + urllib.unquote(line), tableIndex = 2) # all reqs


def Join(key,recs):
    uid = key
    recs_list = []
    for rec in recs:
        recs_list.append(rec)

    isRedir = 0
    isUS = 0

    for rec in recs_list:
        subkey = rec.subkey

        if subkey in c or subkey in e: # есть запись из redir_log
            isRedir = 1
        elif tags[0] in subkey or tags[1] in subkey: # есть запись из user_sessions
            isUS = 1
        else:
            continue

    if isUS == 1 and isRedir == 1: # поджойненные запросы
        for rec in recs_list:
            if not (rec.subkey in e or rec.subkey in c): # оставляем только записи из user_sessions
                yield Record(uid,'',rec.value)

def Aggr(key,recs): # считаем уиды
    uid = key
    i = 0
    for rec in recs:
        i += 1

    yield Record(uid,'',str(i))



def main():

    MapReduce.useDefaults(
                            server   = 'sakura.search.yandex.net:8013',
                            username = 'userstats',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )

    us_output = cluster_path_prefix + '/us_serp_reqs_'
    rd_output = cluster_path_prefix + '/redirects_'

    dd = ['0901','0902','0903','0904','0905','0906','0907']
    for d in dd:

        user_sessions = 'user_sessions/2015' + d
        redir_log = 'redir_log/2015' + d

        # получаем запросы из сессий
        MapReduce.runReduce(GetSerpReqs,
                            srcTable = user_sessions,
                            dstTables = [us_output + 'control',us_output + 'exp'],
                            files = [path_to_blockstat_dict],
                            appendMode = True,
                            sortMode = True
                            )

        # получаем редиректы из redir_log, они расходятся - в контроле больше
        MapReduce.runMap(GrepRedir,
                         srcTable = redir_log,
                         dstTables = [rd_output + 'control',rd_output + 'exp'],
                         appendMode = True,
                         sortMode = True
                        )


    slots = ['control','exp']
    for slot in slots:
        uids_redir = cluster_path_prefix + '/redir_log_uids_' + slot
        uids_us = cluster_path_prefix + '/user_sessions_uids_' + slot

        joined_reqs = cluster_path_prefix + '/joined_reqs_' + slot
        joined_uids = cluster_path_prefix + '/joined_uids_' + slot

        # считаем число уидов по reidr_log в эксперименте и контроле - они сходятся
        MapReduce.runReduce(Aggr,
                            srcTable = rd_output + slot,
                            dstTable = uids_redir,
                            sortMode = True
                           )
        # число уидов по user_sessions в эксперименте и контроле - сходится
        MapReduce.runReduce(Aggr,
                            srcTable = us_output + slot,
                            dstTable = uids_us,
                            sortMode = True
                           )
        # число запросов к серпу у пользователей с редиректами в эксперименте и контроле - расходятся - в контроле больше
        MapReduce.runReduce(Join,
                            srcTables = [us_output + slot, rd_output + slot],
                            dstTable = joined_reqs,
                            sortMode = True
                           )
        # число уидов в поджойненных таблицах - сходится!!
        MapReduce.runReduce(Aggr,
                            srcTable = joined_reqs,
                            dstTable = joined_uids,
                            sortMode = True
                           )

if __name__ == '__main__':
    main()
