#!/usr/local/bin/python
# -*- coding: utf-8

import json
import uuid
import yt.wrapper as yt
import argparse
import re
import time
import urllib2
import datetime
from datetime import date, datetime, timedelta
import requests
from email.mime.text import MIMEText
import smtplib


NO_ANSWER = re.compile(r'(ростите\,? я не знаю что ответить|меня нет ответа на такой запрос|не могу на это ответить|пока не умею отвечать на такие запросы|звините\,? у меня нет хорошего ответа|ничего найти не получилось| не получилось ничего найти| я ничего не нашла| ничего не нашлось)')
SEARCH = re.compile(r'personal\_assistant\.scenarios\.search')
CONVERT = re.compile(r'personal\_assistant\.scenarios\.convert')
VIDEO = re.compile(r'personal\_assistant\.scenarios\.video_play')
CONVERSATION = re.compile(r'personal\_assistant\.general\_conversation\.general\_conversation')
MULTIMEDIA = re.compile(r'personal\_assistant\.scenarios\.(video_play|music_what_is_playing|image_what_is_this|music_play)')

def parse_args():
    parser = argparse.ArgumentParser(add_help=True, description='Suggest metrics calc')
    parser.add_argument('--mr_server', default='hahn', help='MR server (hahn, banach, ...)')
    parser.add_argument('--yt_pool', default='robot-suggestor-dev', help='YT pool')
    parser.add_argument('--input_table', help='path to table with facts')
    parser.add_argument('--timestamp', help='timestamp for metrics in Razladki and Stat')
    parser.add_argument('--stat_user', help="token for Statistics")
    args = parser.parse_args()
    return args

def count_answers(input_table):
    result = {'cnt': 0, 'no_answer': 0, 'conversation': 0, 'answer': 0, 'not_search': 0, 'multimedia': 0, 'other_sc': 0, 'text_answer': 0}
    for row in yt.read_table(input_table):
        try:
            query = row['request']['request']['event']['asr_result'][0]['utterance']
            data = json.loads(row['response'])
            answer = data["voice_response"]["output_speech"]["text"]
            print query,"\t",answer
        except:
            continue
        result['cnt'] += 1
        if NO_ANSWER.search(row['response']):
            result['no_answer'] += 1
        if CONVERSATION.search(row['response']):
            result['conversation'] += 1
        if not SEARCH.search(row['response']):
            result['not_search'] += 1
        if MULTIMEDIA.search(row['response']):
            result['multimedia'] += 1
        if not SEARCH.search(row['response']) and not CONVERSATION.search(row['response']) and not MULTIMEDIA.search(row['response']):
            result['other_sc'] += 1
        if not CONVERSATION.search(row['response']) and not MULTIMEDIA.search(row['response']) and not NO_ANSWER.search(row['response']):
            result['text_answer'] += 1
    result['answer'] = result['cnt'] - result['no_answer'] - result['conversation']
    result['answer_part'] = float(result['answer'])/(result['cnt'] - result['conversation'])*100
    result['no_answer_part'] = float(result['no_answer'])/(result['cnt'] - result['conversation'])*100
    result['conversation_part'] = float(result['conversation'])/float(result['cnt'])*100
    result['coverage'] = float(result['cnt'] - result['no_answer'])/result['cnt']*100
    result['coverage_no_conv'] = float(result['answer'])/result['cnt']*100
    result['not_search_part'] = float(result['not_search'])/result['cnt']*100
    result['multimedia_part'] = float(result['multimedia'])/result['cnt']*100
    result['other_sc_part'] = float(result['other_sc'])/result['cnt']*100
    result['text_sc'] = result['text_answer'] + result['no_answer']
    result['text_answers_part'] = float(result['text_answer'])/(result['text_answer'] + result['no_answer'])*100
    return result

def prefix_metric_name(input_table):
    pref = ''
    if 'assistant_kpi' in input_table:
        pref = 'assistant_kpi'
    elif 'assistant_validate' in input_table:
        pref = 'assistant_validate'
    elif 'top_of_mind_kpi' in input_table:
        pref = 'top_of_mind_kpi'
    elif 'top_of_mind_validate' in input_table:
        pref = 'top_of_mind_validate'
    return pref


def push_to_razladki(prefix, metrics, timestamp):
    for key, value in metrics.items():
        avgName = '{}_{}'.format(prefix, key)
        avgMetrics = value
        try:
            razladkiUrl = 'http://launcher.razladki.yandex-team.ru/save_new_data/%s?%s=%s&ts=%s&override=1' % ("facts_ya_station_recall", avgName, avgMetrics, timestamp[:10])
            print avgName, avgMetrics
            print urllib2.urlopen(razladkiUrl).read()
        except:
            time.sleep(300)


def send_email(prefix, metrics):
    text = ['Полнота ответа по фактовым запросам в Я.Станции С ТВ аномально изменилась']
    for k,v in metrics.items():
        text.append("%s\t%s" % (k, v))
    message = '\n'.join(text)
    msg = MIMEText(message)
    me = 'galamaj@yandex-team.ru'
    recipients = ['galamaj@yandex-team.ru']
    msg['Subject'] = 'Значимо изменилась полнота ответов Я.Станции С ТВ для ' + prefix
    msg['From'] = me
    msg['To'] = ', '.join(recipients)
    s = smtplib.SMTP('outbound-relay.yandex.net')
    try:
        s.sendmail(me, recipients, msg.as_string())
    finally:
        s.quit()


def push_to_stat(prefix, metrics, timestamp, token, scale='d', beta = False, _append_mode=1):
    data = {}
    data['basket'] = '\t' + prefix + '\t'
    date = datetime.fromtimestamp(int(timestamp[:10]))
    data['fielddate'] = date.strftime('%Y-%m-%d')
    if  metrics['coverage'] < 79 or metrics['coverage'] > 88:
        send_email(prefix, metrics)
    else:
        data.update(metrics)
        data = [data]
        name = '/Adhoc/galamaj/facts_ya_station_recall'
        r = requests.post(
            'https://upload.stat.yandex-team.ru/_api/report/data',
                headers = {
                    'Authorization' : 'OAuth ' + token
                },
                data={
                    'name': name,
                    'scale': scale,
                    'json_data': json.dumps({'values': data}),
                    '_append_mode':_append_mode
                },
            )
        print r.text


def push_to_stat2(prefix, metrics, timestamp, token, scale='d', beta = False, _append_mode=1):
    data = {}
    data['basket'] = '\t' + prefix + '\t'
    date = datetime.fromtimestamp(int(timestamp[:10]))
    data['fielddate'] = date.strftime('%Y-%m-%d')
    if  metrics['coverage'] < 79 or metrics['coverage'] > 88:
        send_email(prefix, metrics)
    else:
        data.update(metrics)
        data = [data]
        name = '/Adhoc/galamaj/facts_ya_station_recall_version_2'
        r = requests.post(
                'https://upload.stat.yandex-team.ru/_api/report/data',
                headers = {
                    'Authorization' : 'OAuth ' + token
                },
                data={
                    'name': name,
                    'scale': scale,
                    'json_data': json.dumps({'values': data}),
                    '_append_mode':_append_mode
                },
            )
        print r.text


if __name__ == '__main__':
    args = parse_args()
    input_table = args.input_table
    timestamp = args.timestamp
    stat_user = args.stat_user
    prefix = prefix_metric_name(input_table)
    metrics = count_answers(input_table)
    # metrics = {}
    print metrics
    push_to_razladki(prefix, metrics, timestamp)
    push_to_stat(prefix, metrics, timestamp, stat_user)
    push_to_stat2(prefix, metrics, timestamp, stat_user)

