#!/usr/local/bin/python
# -*- coding: utf-8

import json
import uuid
import yt.wrapper as yt
import argparse
import re
import time
import urllib2
import datetime
from datetime import date, datetime, timedelta
import requests
from email.mime.text import MIMEText
import smtplib

def parse_args():
    parser = argparse.ArgumentParser(add_help=True, description='Suggest metrics calc')
    parser.add_argument('--mr_server', default='hahn', help='MR server (hahn, banach, ...)')
    parser.add_argument('--yt_pool', default='robot-suggestor-dev', help='YT pool')
    parser.add_argument('--input_toloka', help='path to table with toloka results')
    parser.add_argument('--input_scenarios', help='path to table with scenarios')
    parser.add_argument('--output_prefix', help='pref path for result')
    parser.add_argument('--timestamp', help='timestamp to push metrics to stat and razladki')
    parser.add_argument('--stat_user', help="token for Statistics")
    args = parser.parse_args()
    return args


def send_email(prefix, results):
    path_to_node = '//home/suggest-dev/galamaj/facts/quasar/' + prefix
    text = ['Получилось для разметки ', str(int(results)), ' запросов.\n', 'Проверьте результаты прокачки VINS и разметки в толоке по Точности фактов в ', path_to_node]
    message = ''.join(text)
    msg = MIMEText(message)
    me = 'galamaj@yandex-team.ru'
    recipients = ['galamaj@yandex-team.ru']
    msg['Subject'] = 'Для Точности ответов Я.Станции пришло слишком мало результатов'
    msg['From'] = me
    msg['To'] = ', '.join(recipients)
    s = smtplib.SMTP('outbound-relay.yandex.net')
    try:
        s.sendmail(me, recipients, msg.as_string())
    finally:
        s.quit()


def join_with_scenarios(key, rows):
    result = {}
    scenario = None
    query = None
    for row in rows:
        if 'scenario' in row:
            scenario = row['scenario']
        else:
            query = row['query']
            voice_answer = row['voice_answer']
            voice_answer_to_show = row['voice_answer_to_show']
            result = row['result']
            mark_speech = row['mark_speech']
            mark_info = row['mark_info']
    if scenario is not None and query is not None:
        yield {'scenario': scenario,
              'query': query,
              'voice_answer': voice_answer,
              'voice_answer_to_show': voice_answer_to_show,
              'result': result,
              'mark_speech': mark_speech,
              'mark_info': mark_info}


def scenarios_metrics(key, rows):
    total = 0.
    info_bad = 0.
    info_ok = 0.
    ok = 0.
    bad = 0.
    speech_ok = 0.
    speech_bad = 0.
    scenario = key['scenario']
    for row in rows:
        total += 1
        if row['result'] == 'ok':
            ok += 1
        if row['result'] == 'bad':
            bad += 1
        if row['mark_info'] == 'correct_info':
            info_ok += 1
        if row['mark_info'] == 'incorrect_info':
            info_bad += 1
        if row['mark_speech'] == 'speech_bad':
            speech_bad += 1
        if row['mark_speech'] == 'speech_good':
            speech_ok += 1
    if total > 0:
        yield {'scenario': scenario,
               'total': total,
               'incorrect_info': info_bad,
               'incorrect_info_part': info_bad/total*100,
               'correct_info': info_ok,
               'correct_info_part': info_ok/total*100,
               'speech_bad': speech_bad,
               'speech_bad_part': speech_bad/total*100,
               'speech_good': speech_ok,
               'speech_good_part': speech_ok/total*100,
               'result_ok': ok,
               'result_ok_part': ok/total*100,
               'result_bad': bad,
               'result_bad_part': bad/total*100}


def total_metrics(table):
    total = 0.
    info_bad = 0.
    info_ok = 0.
    ok = 0.
    bad = 0.
    speech_ok = 0.
    speech_bad = 0.
    for row in yt.read_table(table):
        total += 1
        if row['result'] == 'ok':
            ok += 1
        if row['result'] == 'bad':
            bad += 1
        if row['mark_info'] == 'correct_info':
            info_ok += 1
        if row['mark_info'] == 'incorrect_info':
            info_bad += 1
        if row['mark_speech'] == 'speech_bad':
            speech_bad += 1
        if row['mark_speech'] == 'speech_good':
            speech_ok += 1
    return [{'scenario': 'all_scenarios',
        'total': total,
        'incorrect_info': info_bad,
        'incorrect_info_part': info_bad/total*100,
        'correct_info': info_ok,
        'correct_info_part': info_ok/total*100,
        'speech_bad': speech_bad,
        'speech_bad_part': speech_bad/total*100,
        'speech_good': speech_ok,
        'speech_good_part': speech_ok/total*100,
        'result_ok': ok,
        'result_ok_part': ok/total*100,
        'result_bad': bad,
        'result_bad_part': bad/total*100}]


def prefix_metric_name(input_table):
    pref = ''
    if 'assistant_kpi' in input_table:
        pref = 'assistant_kpi'
    elif 'assistant_validate' in input_table:
        pref = 'assistant_validate'
    elif 'top_of_mind_kpi' in input_table:
        pref = 'top_of_mind_kpi'
    elif 'top_of_mind_validate' in input_table:
        pref = 'top_of_mind_validate'
    return pref


def push_to_razladki(prefix, metrics, timestamp):
    for key, value in metrics.items():
        avgName = '{}_{}'.format(prefix, key)
        avgMetrics = value
        try:
            razladkiUrl = 'http://launcher.razladki.yandex-team.ru/save_new_data/%s?%s=%s&ts=%s&override=1' % ("facts_ya_station_precision", avgName, avgMetrics, timestamp[:10])
            print avgName, avgMetrics
            print urllib2.urlopen(razladkiUrl).read()
        except:
            time.sleep(300)

def push_to_stat(prefix, metrics_table, date, token, scale='d', beta=False, _append_mode=1):
    data = []
    post_false = False
    results = None
    for row in yt.read_table(metrics_table):
        metrics = {'basket': prefix, 'fielddate': date}
        if row['scenario'] == 'all_scenarios' and row['total'] <= 1600:
            post_false = True
            results = row['total']
        for key,value in row.items():
            if key == 'scenario':
                metrics['scenarios'] = '\t' + value + '\t'
            else:
                metrics[key] = value
        data.append(metrics)
    name = '/Adhoc/galamaj/facts_precision_quasar'
    if post_false is True:
        send_email(prefix, results)
    else:
        r = requests.post(
            'https://upload.stat.yandex-team.ru/_api/report/data',
            headers = {
                'Authorization' : 'OAuth ' + token
            },
            data={
                'name': name,
                'scale': scale,
                'json_data': json.dumps({'values': data}),
                '_append_mode':_append_mode
            },
        )
        print r.text


if __name__ == '__main__':
    args = parse_args()
    input_toloka = args.input_toloka
    input_scenarios = args.input_scenarios
    output_prefix = args.output_prefix
    timestamp = args.timestamp
    stat_user = args.stat_user
    prefix = prefix_metric_name(output_prefix)
    date = datetime.fromtimestamp(int(timestamp[:10])).strftime('%Y-%m-%d')
    print date
    TRTable = output_prefix + '/precision/toloka_results/' + date
    yt.copy(input_toloka, TRTable)
    joinedTable = output_prefix + '/precision/results_with_scenarios/' + date
    if not yt.exists(joinedTable):
        yt.create("table", path = joinedTable, recursive = True, ignore_existing = True, attributes = None)
    outputTable = output_prefix + '/precision/metrics/' + date
    if not yt.exists(outputTable):
        yt.create("table", path = outputTable, recursive = True, ignore_existing = True, attributes = None)
    outputPath = yt.TablePath(name=outputTable, append=True)
    yt.run_sort(input_toloka, sort_by='query')
    yt.run_sort(input_scenarios, sort_by='query')
    yt.run_reduce(join_with_scenarios, [input_toloka, input_scenarios], joinedTable, reduce_by=['query'])
    metrics_all_scenarios = total_metrics(joinedTable)
    yt.write_table(outputPath, metrics_all_scenarios, raw=False)
    yt.run_sort(joinedTable, sort_by='scenario')
    yt.run_reduce(scenarios_metrics, joinedTable, outputPath, reduce_by=['scenario'])
    push_to_stat(prefix, outputPath, date, stat_user)
    # push_to_razladki(prefix, metrics, timestamp)
