#!/usr/local/bin/python
# -*- coding: utf-8

import yt.wrapper as yt
import argparse


def parse_args():
    parser = argparse.ArgumentParser(add_help=True, description='Suggest metrics calc')
    parser.add_argument('--mr_server', default='hahn', help='MR server (hahn, banach, ...)')
    parser.add_argument('--yt_pool', default='robot-suggestor-dev', help='YT pool')
    parser.add_argument('--input_table', help='path to table with facts')
    parser.add_argument('--output_table', help='path to table with prepared facts for VINS requests')
    args = parser.parse_args()
    return args

def generate_table(row):
    import uuid
    text = row["query"]
    request_id = "ffffffff-ffff-ffff" + str(uuid.uuid4())[18:-1]
    device_state = {"is_tv_plugged_in": False}
    app = {"app_id": "ru.yandex.quasar.services", "app_version": "1.0", "device_manufacturer": "Yandex", "device_model": "Station", "os_version": "6.0.1", "platform": "android"}
    yield {
        "text": text,
        "request_id": request_id,
        "device_state": device_state,
        "app": app
    }

if __name__ == '__main__':
    args = parse_args()
    input_table = args.input_table
    output_table = args.output_table
    yt.run_map(generate_table, input_table, output_table)

