import sys
import libra
from mapreducelib import MapReduce, Record




def extract_clicks(key, recs):
    try:
        for item in libra.ParseSession(recs, "blockstat.dict"):
#           if not item.IsA("TYandexWebRequest"):
#               continue
            if not item.IsA("TTouchYandexWebRequest"):
               continue
            sugg =  item.GetSuggest()
            if not sugg:
                continue
            bro = item.GetBrowser()
            yield Record(
                item.UID,
                str(bro[0]),
                str(bro[1]))
    except:
        pass


if __name__ == "__main__":
    try:
        src_table, dst_table = sys.argv[1:]
    except:
        print "Usage: %s <src_table> <dst_table>" % sys.argv[0]
        sys.exit(1)

    MapReduce.useDefaults(verbose=True, mrExec="mapreduce", server="sakura00.search.yandex.net:8013", username="suggest")
    MapReduce.runReduce(extract_clicks, srcTable=src_table, dstTable=dst_table, files=["blockstat.dict"])
