#!/usr/bin/env python
# -*- coding: utf-8 -*-
import re
import urlparse

from datetime import datetime, timedelta

# If some field has incorrect format, all this functions will return nothing,
# it's OK for YQL and means nullable value

####################################################################################################

def Unquote(value):
    if value is None:
        return
    try:
        return urlparse.unquote(value)
    except AttributeError:
        return

####################################################################################################

def GetIp(ip):
    if ip is not None:
        ip = ip.split(",")
        return ip[0]
    return

####################################################################################################

def GetService(path):
    if path is not None:
        fields = path.split('.')
        if len(fields) > 0:
            return fields[0]
    return

def GetActionType(path):
    if path is not None:
        fields = path.split('.')
        if len(fields) > 1:
            return fields[1]
    return

def GetSuggestionPos(path):
    if path is not None:
        fields = path.split('.')
        if len(fields) > 2 and fields[2].startswith('p') and fields[2][1:].isdigit():
            suggest_position = int(fields[2][1:])
            if suggest_position != 0:
                return suggest_position - 1
    return

def GetSubmitType(path):
    if path is not None:
        fields = path.split('.')
        if len(fields) > 4:
            return fields[4]
    return

####################################################################################################

def GetLr(http_referer):
    if http_referer is not None:
        parts = http_referer.split('lr=')
        if len(parts) > 1:
            parts = re.findall('[0-9]+', parts[1])
            if len(parts) > 0 and parts[0].isdigit():
                return int(parts[0])
    return

####################################################################################################

def GetSuggestTypes(log):
    if log is not None:
        log = log.replace('sgtype%3A', '')
        suggest_types = re.findall('[A-Z][^A-Z]*', log)
        if len(suggest_types) > 0:
            return suggest_types
    return

####################################################################################################

def GetSymbolsCount(ratio):
    if ratio is not None:
        fields = ratio.split('.')
        if len(fields) > 0 and fields[0].isdigit():
            return int(fields[0])
    return

def GetQueryLength(ratio):
    if ratio is not None:
        fields = ratio.split('.')
        if len(fields) > 1 and fields[1].isdigit():
            return int(fields[1])
    return

def GetUserActionsCount(ratio):
    if ratio is not None:
        fields = ratio.split('.')
        if len(fields) > 2 and fields[2].isdigit():
            return int(fields[2])
    return

####################################################################################################

def GetYAMRFieldByName(value, name):
    for pair in value.split('\t'):
        fields = pair.split('=')
        if len(fields) > 1:
            if fields[0] == name:
                return '='.join(fields[1:])
    return

####################################################################################################

def get_dates(timestamp, from_date, to_date):
    dates = []
    date_format = '%Y-%m-%d'
    if timestamp:
        date = datetime.fromtimestamp(int(timestamp[:10]))
        dates.append(date.strftime(date_format))

    if from_date and not to_date:
        to_date = datetime.strftime(datetime.now(), date_format)

    if from_date and to_date:
        current_date = datetime.strptime(from_date, date_format)
        while current_date <= datetime.strptime(to_date, date_format):
            dates.append(current_date.strftime(date_format))
            current_date += timedelta(1)

    return dates

####################################################################################################
